/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.init;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;
import net.povstalec.sgjourney.common.init.FeatureInit;

public class PlacedFeatureInit {
    public static final ResourceKey<PlacedFeature> STONE_NAQUADAH_SPIRE_PLACED_KEY = PlacedFeatureInit.createKey("stone_naquadah_spire");
    public static final ResourceKey<PlacedFeature> BLACKSTONE_NAQUADAH_SPIRE_PLACED_KEY = PlacedFeatureInit.createKey("blackstone_naquadah_spire");
    private static final PlacementModifier ORE_SPIRE_THRESHOLD = SurfaceWaterDepthFilter.m_191950_((int)0);

    public static void bootstrap(BootstapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.m_255420_(Registries.f_256911_);
        PlacedFeatureInit.register(context, STONE_NAQUADAH_SPIRE_PLACED_KEY, configuredFeatures.m_255043_(FeatureInit.STONE_NAQUADAH_SPIRE_KEY), PlacedFeatureInit.oreSpirePlacement(PlacementUtils.m_195364_((int)0, (float)0.01f, (int)1)));
        PlacedFeatureInit.register(context, BLACKSTONE_NAQUADAH_SPIRE_PLACED_KEY, configuredFeatures.m_255043_(FeatureInit.BLACKSTONE_NAQUADAH_SPIRE_KEY), PlacedFeatureInit.oreSpirePlacement(PlacementUtils.m_195364_((int)0, (float)0.01f, (int)1)));
    }

    private static ResourceKey<PlacedFeature> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("sgjourney", name));
    }

    private static void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.m_255272_(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }

    private static void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, PlacementModifier ... modifiers) {
        PlacedFeatureInit.register(context, key, configuration, List.of(modifiers));
    }

    private static List<PlacementModifier> oreSpirePlacement(PlacementModifier modifier) {
        return ImmutableList.builder().add((Object)modifier).add((Object)InSquarePlacement.m_191715_()).add((Object)ORE_SPIRE_THRESHOLD).add((Object)PlacementUtils.f_195355_).add((Object)BiomeFilter.m_191561_()).build();
    }
}

