/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.entities.goals;

import java.util.EnumSet;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.povstalec.sgjourney.common.items.StaffWeaponItem;

public class StaffWeaponAttackGoal<T extends Mob>
extends Goal {
    public static final int ATTACK_DELAY = 40;
    public static final UniformInt PATHFINDING_DELAY_RANGE = TimeUtil.m_145020_((int)1, (int)2);
    private final T mob;
    private final double speedModifier;
    private final float meleeAttackRadiusSqr;
    private final float maxAttackRadiusSqr;
    private int seeTime;
    private int attackDelay;
    private int updatePathDelay;

    public StaffWeaponAttackGoal(T mob, double speedModifier, float meleeRadius, float maxRadius) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.meleeAttackRadiusSqr = meleeRadius * meleeRadius;
        this.maxAttackRadiusSqr = maxRadius * maxRadius;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.attackDelay = 40;
    }

    public boolean m_8036_() {
        return this.isValidTarget() && this.isHoldingStaffWeapon();
    }

    private boolean isHoldingStaffWeapon() {
        return this.mob.m_21093_(is -> is.m_41720_() instanceof StaffWeaponItem);
    }

    public boolean m_8045_() {
        return this.isValidTarget() && (this.m_8036_() || !this.mob.m_21573_().m_26571_()) && this.isHoldingStaffWeapon();
    }

    private boolean isValidTarget() {
        if (this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_()) {
            return this.mob.m_20280_((Entity)this.mob.m_5448_()) > (double)this.meleeAttackRadiusSqr;
        }
        return false;
    }

    public void m_8041_() {
        super.m_8041_();
        this.mob.m_21561_(false);
        this.mob.m_6710_(null);
        this.seeTime = 0;
        if (this.mob.m_6117_()) {
            this.mob.m_5810_();
        }
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        boolean shouldMoveToTarget;
        boolean hasSeenTarget;
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity == null) {
            return;
        }
        boolean hasLineOfSight = this.mob.m_21574_().m_148306_((Entity)livingentity);
        boolean bl = hasSeenTarget = this.seeTime > 0;
        if (hasLineOfSight != hasSeenTarget) {
            this.seeTime = 0;
        }
        this.seeTime = hasLineOfSight ? ++this.seeTime : --this.seeTime;
        double distanceSqr = this.mob.m_20280_((Entity)livingentity);
        boolean bl2 = shouldMoveToTarget = (distanceSqr > (double)this.maxAttackRadiusSqr || this.seeTime < 5) && this.attackDelay == 0;
        if (shouldMoveToTarget) {
            --this.updatePathDelay;
            if (this.updatePathDelay <= 0) {
                this.mob.m_21573_().m_5624_((Entity)livingentity, this.speedModifier);
                this.updatePathDelay = PATHFINDING_DELAY_RANGE.m_214085_(this.mob.m_217043_());
            }
        } else {
            this.updatePathDelay = 0;
            this.mob.m_21573_().m_26573_();
        }
        this.mob.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
        if (this.attackDelay > 0) {
            --this.attackDelay;
        } else {
            ((RangedAttackMob)this.mob).m_6504_(livingentity, 1.0f);
            this.attackDelay = 40;
        }
    }
}

