/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class CommonTechConfig {
    public static ForgeConfigSpec.BooleanValue fusion_core_infinite_energy;
    public static ForgeConfigSpec.LongValue fusion_core_energy_from_fuel;
    public static ForgeConfigSpec.IntValue fusion_core_fuel_capacity;
    public static ForgeConfigSpec.BooleanValue disable_kara_kesh_requirements;
    public static ForgeConfigSpec.IntValue personal_shield_capacity;
    public static ForgeConfigSpec.LongValue energy_crystal_capacity;
    public static ForgeConfigSpec.LongValue advanced_energy_crystal_capacity;
    public static ForgeConfigSpec.LongValue energy_crystal_max_transfer;
    public static ForgeConfigSpec.LongValue advanced_energy_crystal_max_transfer;
    public static ForgeConfigSpec.LongValue transfer_crystal_max_transfer;
    public static ForgeConfigSpec.LongValue advanced_transfer_crystal_max_transfer;

    public static void init(ForgeConfigSpec.Builder server) {
        fusion_core_infinite_energy = server.comment("If true, Fusion Core will produce an endless amount of energy and won't require any fuel").define("server.fusion_core_infinite_energy", false);
        fusion_core_energy_from_fuel = server.comment("The amount of energy generated by Fusion Core from one unit of fuel").defineInRange("server.fusion_core_energy_from_fuel", 100000L, 1L, Long.MAX_VALUE);
        fusion_core_fuel_capacity = server.comment("The fuel capacity of a Fusion Core").defineInRange("server.fusion_core_fuel_capacity", 65536, 1, Integer.MAX_VALUE);
        disable_kara_kesh_requirements = server.comment("If true Kara Kesh won't require its user to have Naquadah in their bloodstream").define("server.disable_kara_kesh_requirements", true);
        personal_shield_capacity = server.comment("The amount of Heavy Liquid Naquadah a Personal Shield can hold").defineInRange("server.personal_shield_capacity", 300, 1, 10000);
        energy_crystal_capacity = server.comment("The amount of energy an Energy Crystal can hold").defineInRange("server.energy_crystal_capacity", 50000L, 1L, Long.MAX_VALUE);
        advanced_energy_crystal_capacity = server.comment("The amount of energy an Advanced Energy Crystal can hold").defineInRange("server.advanced_energy_crystal_capacity", 100000L, 1L, Long.MAX_VALUE);
        energy_crystal_max_transfer = server.comment("The amount of energy that can be transfered into and out of an Energy Crystal per tick").defineInRange("server.energy_crystal_max_transfer", 1500L, 1L, Long.MAX_VALUE);
        advanced_energy_crystal_max_transfer = server.comment("The amount of energy that can be transfered into and out of an Advanced Energy Crystal per tick").defineInRange("server.advanced_energy_crystal_max_transfer", 3000L, 1L, Long.MAX_VALUE);
        transfer_crystal_max_transfer = server.comment("The amount of energy a Transfer Crystal can transfer per tick").defineInRange("server.transfer_crystal_max_transfer", 2500L, 1L, Long.MAX_VALUE);
        advanced_transfer_crystal_max_transfer = server.comment("The amount of energy an Advanced Transfer Crystal can transfer per tick").defineInRange("server.advanced_transfer_crystal_max_transfer", 5000L, 1L, Long.MAX_VALUE);
    }
}

