/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.compatibility.jei;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.povstalec.sgjourney.common.compatibility.jei.AdvancedCrystallizerRecipeCategory;
import net.povstalec.sgjourney.common.compatibility.jei.CrystallizerRecipeCategory;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.recipe.AdvancedCrystallizerRecipe;
import net.povstalec.sgjourney.common.recipe.CrystallizerRecipe;

@JeiPlugin
public class SGJourneyJEIPlugin
implements IModPlugin {
    private static final ResourceLocation PLUGIN_LOCATION = new ResourceLocation("sgjourney", "jei_plugin");
    private static Minecraft minecraft = Minecraft.m_91087_();

    public ResourceLocation getPluginUid() {
        return PLUGIN_LOCATION;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new CrystallizerRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new AdvancedCrystallizerRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Objects.requireNonNull(SGJourneyJEIPlugin.minecraft.f_91073_).m_7465_();
        List crystallizerRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)CrystallizerRecipe.Type.INSTANCE);
        registration.addRecipes(new RecipeType(CrystallizerRecipeCategory.RECIPE_ID, CrystallizerRecipe.class), crystallizerRecipes);
        List advancedCrystallizerRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)AdvancedCrystallizerRecipe.Type.INSTANCE);
        registration.addRecipes(new RecipeType(AdvancedCrystallizerRecipeCategory.RECIPE_ID, AdvancedCrystallizerRecipe.class), advancedCrystallizerRecipes);
    }

    public void registerRecipeCatalysts(@Nonnull IRecipeCatalystRegistration registration) {
        BlockInit.CRYSTALLIZER.ifPresent(crystallizerBlock -> {
            Item item = crystallizerBlock.m_5456_();
            if (item != null) {
                registration.addRecipeCatalyst(new ItemStack((ItemLike)item), new RecipeType[]{CrystallizerRecipeCategory.CRYSTALLIZING_TYPE});
            }
        });
        BlockInit.ADVANCED_CRYSTALLIZER.ifPresent(crystallizerBlock -> {
            Item item = crystallizerBlock.m_5456_();
            if (item != null) {
                registration.addRecipeCatalyst(new ItemStack((ItemLike)item), new RecipeType[]{AdvancedCrystallizerRecipeCategory.ADVANCED_CRYSTALLIZING_TYPE});
            }
        });
    }
}

