/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blockstates;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.event.ForgeEventFactory;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBlock;
import net.povstalec.sgjourney.common.blockstates.StargatePart;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.sgjourney.StargateBlockCover;
import net.povstalec.sgjourney.common.sgjourney.StargateConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StargateBlockState
extends BlockState {
    public StargateBlockState(Block block, ImmutableMap<Property<?>, Comparable<?>> properties, MapCodec<BlockState> states) {
        super(block, properties, states);
    }

    public float m_60800_(BlockGetter reader, BlockPos pos) {
        Block block = this.m_60734_();
        if (block instanceof AbstractStargateBlock) {
            StargateConnection.State state;
            AbstractStargateBlock stargateBlock = (AbstractStargateBlock)block;
            AbstractStargateEntity stargate = stargateBlock.getStargate(reader, pos, reader.m_8055_(pos));
            if (stargate != null && !((Boolean)CommonStargateConfig.can_break_connected_stargate.get()).booleanValue() && (state = stargate.getConnectionState()).isConnected()) {
                return -1.0f;
            }
            Optional<StargateBlockCover> blockCover = stargateBlock.getBlockCover(reader, this, pos);
            if (blockCover.isPresent()) {
                StargatePart part = (StargatePart)((Object)this.m_61143_((Property)AbstractStargateBlock.PART));
                Optional<BlockState> coverState = blockCover.get().getBlockAt(part);
                if (coverState.isPresent()) {
                    return coverState.get().m_60800_(reader, pos);
                }
            }
        }
        return super.m_60800_(reader, pos);
    }

    public float m_60625_(Player player, BlockGetter reader, BlockPos pos) {
        AbstractStargateBlock stargate;
        Optional<StargateBlockCover> blockCover;
        float destroySpeed = this.m_60800_(reader, pos);
        if (destroySpeed == -1.0f) {
            return 0.0f;
        }
        Block block = this.m_60734_();
        if (block instanceof AbstractStargateBlock && (blockCover = (stargate = (AbstractStargateBlock)block).getBlockCover(reader, this, pos)).isPresent()) {
            StargatePart part = (StargatePart)((Object)this.m_61143_((Property)AbstractStargateBlock.PART));
            Optional<BlockState> coverState = blockCover.get().getBlockAt(part);
            if (coverState.isPresent()) {
                float multiplier = ForgeHooks.isCorrectToolForDrops((BlockState)coverState.get(), (Player)player) ? 30.0f : 100.0f;
                return player.getDigSpeed(coverState.get(), pos) / destroySpeed / multiplier;
            }
        }
        return super.m_60625_(player, reader, pos);
    }

    public SoundType getSoundType(LevelReader level, BlockPos pos, @Nullable Entity entity) {
        AbstractStargateBlock stargate;
        Optional<StargateBlockCover> blockCover;
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof AbstractStargateBlock && (blockCover = (stargate = (AbstractStargateBlock)block).getBlockCover((BlockGetter)level, state, pos)).isPresent()) {
            StargatePart part = (StargatePart)((Object)state.m_61143_(AbstractStargateBlock.PART));
            Optional<BlockState> coverState = blockCover.get().getBlockAt(part);
            if (coverState.isPresent()) {
                return coverState.get().getSoundType(level, pos, entity);
            }
        }
        return super.getSoundType(level, pos, entity);
    }

    private BlockState self() {
        return this;
    }

    public float getFriction(LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return this.self().m_60734_().getFriction(this.self(), level, pos, entity);
    }

    public int getLightEmission(BlockGetter level, BlockPos pos) {
        return this.self().m_60734_().getLightEmission(this.self(), level, pos);
    }

    public boolean isLadder(LevelReader level, BlockPos pos, LivingEntity entity) {
        return this.self().m_60734_().isLadder(this.self(), level, pos, entity);
    }

    public boolean canHarvestBlock(BlockGetter level, BlockPos pos, Player player) {
        return this.self().m_60734_().canHarvestBlock(this.self(), level, pos, player);
    }

    public boolean onDestroyedByPlayer(Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        return this.self().m_60734_().onDestroyedByPlayer(this.self(), level, pos, player, willHarvest, fluid);
    }

    public boolean isBed(BlockGetter level, BlockPos pos, @Nullable LivingEntity sleeper) {
        return this.self().m_60734_().isBed(this.self(), level, pos, (Entity)sleeper);
    }

    public boolean isValidSpawn(LevelReader level, BlockPos pos, SpawnPlacements.Type type, EntityType<?> entityType) {
        return this.self().m_60734_().isValidSpawn(this.self(), (BlockGetter)level, pos, type, entityType);
    }

    public Optional<Vec3> getRespawnPosition(EntityType<?> type, LevelReader level, BlockPos pos, float orientation, @Nullable LivingEntity entity) {
        return this.self().m_60734_().getRespawnPosition(this.self(), type, level, pos, orientation, entity);
    }

    public void setBedOccupied(Level level, BlockPos pos, LivingEntity sleeper, boolean occupied) {
        this.self().m_60734_().setBedOccupied(this.self(), level, pos, sleeper, occupied);
    }

    public Direction getBedDirection(LevelReader level, BlockPos pos) {
        return this.self().m_60734_().getBedDirection(this.self(), level, pos);
    }

    public float getExplosionResistance(BlockGetter level, BlockPos pos, Explosion explosion) {
        return this.self().m_60734_().getExplosionResistance(this.self(), level, pos, explosion);
    }

    public ItemStack getCloneItemStack(HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return this.self().m_60734_().getCloneItemStack(this.self(), target, level, pos, player);
    }

    public boolean addLandingEffects(ServerLevel level, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return this.self().m_60734_().addLandingEffects(this.self(), level, pos, state2, entity, numberOfParticles);
    }

    public boolean addRunningEffects(Level level, BlockPos pos, Entity entity) {
        return this.self().m_60734_().addRunningEffects(this.self(), level, pos, entity);
    }

    public boolean canSustainPlant(BlockGetter level, BlockPos pos, Direction facing, IPlantable plantable) {
        return this.self().m_60734_().canSustainPlant(this.self(), level, pos, facing, plantable);
    }

    public boolean onTreeGrow(LevelReader level, BiConsumer<BlockPos, BlockState> placeFunction, RandomSource randomSource, BlockPos pos, TreeConfiguration config) {
        return this.self().m_60734_().onTreeGrow(this.self(), level, placeFunction, randomSource, pos, config);
    }

    public boolean isFertile(BlockGetter level, BlockPos pos) {
        return this.self().m_60734_().isFertile(this.self(), level, pos);
    }

    public boolean isConduitFrame(LevelReader level, BlockPos pos, BlockPos conduit) {
        return this.self().m_60734_().isConduitFrame(this.self(), level, pos, conduit);
    }

    public boolean isPortalFrame(BlockGetter level, BlockPos pos) {
        return this.self().m_60734_().isPortalFrame(this.self(), level, pos);
    }

    public int getExpDrop(LevelReader level, RandomSource randomSource, BlockPos pos, int fortuneLevel, int silkTouchLevel) {
        return this.self().m_60734_().getExpDrop(this.self(), level, randomSource, pos, fortuneLevel, silkTouchLevel);
    }

    public BlockState rotate(LevelAccessor level, BlockPos pos, Rotation direction) {
        return this.self().m_60734_().rotate(this.self(), level, pos, direction);
    }

    public float getEnchantPowerBonus(LevelReader level, BlockPos pos) {
        return this.self().m_60734_().getEnchantPowerBonus(this.self(), level, pos);
    }

    public void onNeighborChange(LevelReader level, BlockPos pos, BlockPos neighbor) {
        this.self().m_60734_().onNeighborChange(this.self(), level, pos, neighbor);
    }

    public boolean shouldCheckWeakPower(SignalGetter level, BlockPos pos, Direction side) {
        return this.self().m_60734_().shouldCheckWeakPower(this.self(), level, pos, side);
    }

    public boolean getWeakChanges(LevelReader level, BlockPos pos) {
        return this.self().m_60734_().getWeakChanges(this.self(), level, pos);
    }

    @Nullable
    public float[] getBeaconColorMultiplier(LevelReader level, BlockPos pos, BlockPos beacon) {
        return this.self().m_60734_().getBeaconColorMultiplier(this.self(), level, pos, beacon);
    }

    public BlockState getStateAtViewpoint(BlockGetter level, BlockPos pos, Vec3 viewpoint) {
        return this.self().m_60734_().getStateAtViewpoint(this.self(), level, pos, viewpoint);
    }

    public boolean isSlimeBlock() {
        return this.self().m_60734_().isSlimeBlock(this.self());
    }

    public boolean isStickyBlock() {
        return this.self().m_60734_().isStickyBlock(this.self());
    }

    public boolean canStickTo(@NotNull BlockState other) {
        return this.self().m_60734_().canStickTo(this.self(), other);
    }

    public int getFlammability(BlockGetter level, BlockPos pos, Direction face) {
        return this.self().m_60734_().getFlammability(this.self(), level, pos, face);
    }

    public boolean isFlammable(BlockGetter level, BlockPos pos, Direction face) {
        return this.self().m_60734_().isFlammable(this.self(), level, pos, face);
    }

    public void onCaughtFire(Level level, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
        this.self().m_60734_().onCaughtFire(this.self(), level, pos, face, igniter);
    }

    public int getFireSpreadSpeed(BlockGetter level, BlockPos pos, Direction face) {
        return this.self().m_60734_().getFireSpreadSpeed(this.self(), level, pos, face);
    }

    public boolean isFireSource(LevelReader level, BlockPos pos, Direction side) {
        return this.self().m_60734_().isFireSource(this.self(), level, pos, side);
    }

    public boolean canEntityDestroy(BlockGetter level, BlockPos pos, Entity entity) {
        return this.self().m_60734_().canEntityDestroy(this.self(), level, pos, entity);
    }

    public boolean isBurning(BlockGetter level, BlockPos pos) {
        return this.self().m_60734_().isBurning(this.self(), level, pos);
    }

    @Nullable
    public BlockPathTypes getBlockPathType(BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return this.self().m_60734_().getBlockPathType(this.self(), level, pos, mob);
    }

    @Nullable
    public BlockPathTypes getAdjacentBlockPathType(BlockGetter level, BlockPos pos, @Nullable Mob mob, BlockPathTypes originalType) {
        return this.self().m_60734_().getAdjacentBlockPathType(this.self(), level, pos, mob, originalType);
    }

    public boolean canDropFromExplosion(BlockGetter level, BlockPos pos, Explosion explosion) {
        return this.self().m_60734_().canDropFromExplosion(this.self(), level, pos, explosion);
    }

    public void onBlockExploded(Level level, BlockPos pos, Explosion explosion) {
        this.self().m_60734_().onBlockExploded(this.self(), level, pos, explosion);
    }

    public boolean collisionExtendsVertically(BlockGetter level, BlockPos pos, Entity collidingEntity) {
        return this.self().m_60734_().collisionExtendsVertically(this.self(), level, pos, collidingEntity);
    }

    public boolean shouldDisplayFluidOverlay(BlockAndTintGetter level, BlockPos pos, FluidState fluidState) {
        return this.self().m_60734_().shouldDisplayFluidOverlay(this.self(), level, pos, fluidState);
    }

    @Nullable
    public BlockState getToolModifiedState(UseOnContext context, ToolAction toolAction, boolean simulate) {
        BlockState eventState = ForgeEventFactory.onToolUse((BlockState)this.self(), (UseOnContext)context, (ToolAction)toolAction, (boolean)simulate);
        return eventState != this.self() ? eventState : this.self().m_60734_().getToolModifiedState(this.self(), context, toolAction, simulate);
    }

    public boolean isScaffolding(LivingEntity entity) {
        return this.self().m_60734_().isScaffolding(this.self(), (LevelReader)entity.m_9236_(), entity.m_20183_(), entity);
    }

    public boolean canRedstoneConnectTo(BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return this.self().m_60734_().canConnectRedstone(this.self(), level, pos, direction);
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState neighborState, Direction dir) {
        return this.self().m_60734_().hidesNeighborFace(level, pos, this.self(), neighborState, dir);
    }

    public boolean supportsExternalFaceHiding() {
        return this.self().m_60734_().supportsExternalFaceHiding(this.self());
    }

    public void onBlockStateChange(LevelReader level, BlockPos pos, BlockState oldState) {
        this.self().m_60734_().onBlockStateChange(level, pos, oldState, this.self());
    }

    public boolean canBeHydrated(BlockGetter getter, BlockPos pos, FluidState fluid, BlockPos fluidPos) {
        return this.self().m_60734_().canBeHydrated(this.self(), getter, pos, fluid, fluidPos);
    }

    public BlockState getAppearance(BlockAndTintGetter level, BlockPos pos, Direction side, @Nullable BlockState queryState, @Nullable BlockPos queryPos) {
        return this.self().m_60734_().getAppearance(this.self(), level, pos, side, queryState, queryPos);
    }
}

