/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks.stargate;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.povstalec.sgjourney.common.block_entities.stargate.PegasusStargateEntity;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBaseBlock;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateRingBlock;
import net.povstalec.sgjourney.common.blocks.stargate.shielding.AbstractShieldingBlock;
import net.povstalec.sgjourney.common.config.ClientStargateConfig;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.sgjourney.PointOfOrigin;
import net.povstalec.sgjourney.common.sgjourney.Symbols;

public class PegasusStargateBlock
extends AbstractStargateBaseBlock {
    public PegasusStargateBlock(BlockBehaviour.Properties properties) {
        super(properties, 7.0, 1.0);
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        PegasusStargateEntity stargate = new PegasusStargateEntity(pos, state);
        return stargate;
    }

    @Override
    public AbstractStargateRingBlock getRing() {
        return (AbstractStargateRingBlock)BlockInit.PEGASUS_RING.get();
    }

    @Override
    public AbstractShieldingBlock getIris() {
        return (AbstractShieldingBlock)BlockInit.PEGASUS_SHIELDING.get();
    }

    @Override
    public BlockState ringState() {
        return this.getRing().m_49966_();
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.m_5776_()) {
            return null;
        }
        return PegasusStargateBlock.createTickerHelper(type, (BlockEntityType)BlockEntityInit.PEGASUS_STARGATE.get(), PegasusStargateEntity::tick);
    }

    @Override
    public void m_5871_(ItemStack stack, @Nullable BlockGetter getter, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientPacketListener clientPacketListener = minecraft.m_91403_();
        if (clientPacketListener != null) {
            RegistryAccess registries = clientPacketListener.m_105152_();
            Registry pointOfOriginRegistry = registries.m_175515_(PointOfOrigin.REGISTRY_KEY);
            Registry symbolsRegistry = registries.m_175515_(Symbols.REGISTRY_KEY);
            if (!stack.m_41782_() || stack.m_41782_() && stack.m_41783_().m_128469_("BlockEntityTag").m_128441_("DynamicSymbols") && stack.m_41783_().m_128469_("BlockEntityTag").m_128471_("DynamicSymbols")) {
                tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.dynamic_symbols").m_130940_(ChatFormatting.DARK_AQUA));
            } else {
                String pointOfOrigin = "";
                if (stack.m_41782_() && stack.m_41783_().m_128469_("BlockEntityTag").m_128441_("PointOfOrigin")) {
                    ResourceLocation location = new ResourceLocation(stack.m_41783_().m_128469_("BlockEntityTag").m_128461_("PointOfOrigin"));
                    pointOfOrigin = location.toString().equals("sgjourney:empty") ? "Empty" : (pointOfOriginRegistry.m_7804_(location) ? ((PointOfOrigin)pointOfOriginRegistry.m_7745_(location)).getName() : "Error");
                }
                String symbols = "";
                if (stack.m_41782_() && stack.m_41783_().m_128469_("BlockEntityTag").m_128441_("Symbols")) {
                    ResourceLocation location = new ResourceLocation(stack.m_41783_().m_128469_("BlockEntityTag").m_128461_("Symbols"));
                    symbols = location.toString().equals("sgjourney:empty") ? "Empty" : (symbolsRegistry.m_7804_(location) ? ((Symbols)symbolsRegistry.m_7745_(location)).getTranslationName(!ClientStargateConfig.unique_symbols.get()) : "Error");
                }
                tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.point_of_origin").m_7220_((Component)Component.m_237113_((String)": ")).m_7220_((Component)Component.m_237115_((String)pointOfOrigin)).m_130940_(ChatFormatting.DARK_PURPLE));
                tooltipComponents.add((Component)Component.m_237115_((String)Symbols.symbolsOrSet()).m_7220_((Component)Component.m_237113_((String)": ")).m_7220_((Component)Component.m_237115_((String)symbols)).m_130940_(ChatFormatting.LIGHT_PURPLE));
            }
        }
        super.m_5871_(stack, getter, tooltipComponents, isAdvanced);
    }

    public static ItemStack localSymbols(ItemStack stack) {
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.m_128379_("DynamicSymbols", false);
        stack.m_41700_("BlockEntityTag", (Tag)compoundtag);
        return stack;
    }
}

