/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.tech;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;
import net.povstalec.sgjourney.common.block_entities.EnergyBlockEntity;
import net.povstalec.sgjourney.common.blocks.tech.AbstractCrystallizerBlock;
import net.povstalec.sgjourney.common.init.PacketHandlerInit;
import net.povstalec.sgjourney.common.packets.ClientboundCrystallizerUpdatePacket;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCrystallizerEntity
extends EnergyBlockEntity {
    private static final String INVENTORY = "Inventory";
    private static final String PROGRESS = "progress";
    private static final String CRYSTAL_BASE_INVENTORY = "crystal_base_inventory";
    private static final String PRIMARY_INGREDIENT_INVENTORY = "primary_ingredient_inventory";
    private static final String SECONDARY_INGREDIENT_INVENTORY = "secondary_ingredient_inventory";
    private static final String OUTPUT_INVENTORY = "output_inventory";
    private static final String FLUID_INPUT_INVENTORY = "fluid_input_inventory";
    public static final int LIQUID_NAQUADAH_CAPACITY = 4000;
    public static final int MAX_PROGRESS = 200;
    protected final ItemStackHandler crystalBaseHandler = this.createCrystalBaseHandler();
    protected final LazyOptional<IItemHandler> lazyCrystalBaseHandler = LazyOptional.of(() -> this.crystalBaseHandler);
    protected final ItemStackHandler primaryIngredientHandler = this.createIngredientHandler();
    protected final LazyOptional<IItemHandler> lazyPrimaryIngredientHandler = LazyOptional.of(() -> this.primaryIngredientHandler);
    protected final ItemStackHandler secondaryIngredientHandler = this.createIngredientHandler();
    protected final LazyOptional<IItemHandler> lazySecondaryIngredientHandler = LazyOptional.of(() -> this.secondaryIngredientHandler);
    protected final ItemStackHandler outputHandler = this.createOutputHandler();
    protected final LazyOptional<IItemHandler> lazyOutputHandler = LazyOptional.of(() -> this.outputHandler);
    protected final ItemStackHandler fluidInputHandler = this.createFluidInputHandler();
    protected final LazyOptional<IItemHandler> lazyFluidInputHandler = LazyOptional.of(() -> this.fluidInputHandler);
    protected LazyOptional<IFluidHandler> lazyFluidHandler = LazyOptional.empty();
    public int progress = 0;
    private final FluidTank fluidTank = new FluidTank(4000){

        protected void onContentsChanged() {
            AbstractCrystallizerEntity.this.m_6596_();
        }

        public boolean isFluidValid(FluidStack stack) {
            return stack.getFluid() == AbstractCrystallizerEntity.this.getDesiredFluid();
        }
    };

    public AbstractCrystallizerEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.lazyFluidHandler = LazyOptional.of(() -> this.fluidTank);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyCrystalBaseHandler.invalidate();
        this.lazyPrimaryIngredientHandler.invalidate();
        this.lazySecondaryIngredientHandler.invalidate();
        this.lazyOutputHandler.invalidate();
        this.lazyFluidInputHandler.invalidate();
        this.lazyFluidHandler.invalidate();
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_(INVENTORY)) {
            ItemStackHandler itemHandler = new ItemStackHandler(5);
            itemHandler.deserializeNBT(nbt.m_128469_(INVENTORY));
            this.crystalBaseHandler.insertItem(0, itemHandler.getStackInSlot(0), false);
            this.primaryIngredientHandler.insertItem(0, itemHandler.getStackInSlot(1), false);
            this.secondaryIngredientHandler.insertItem(0, itemHandler.getStackInSlot(2), false);
            this.outputHandler.insertItem(0, itemHandler.getStackInSlot(3), false);
            this.fluidInputHandler.insertItem(0, itemHandler.getStackInSlot(4), false);
        } else {
            this.crystalBaseHandler.deserializeNBT(nbt.m_128469_(CRYSTAL_BASE_INVENTORY));
            this.primaryIngredientHandler.deserializeNBT(nbt.m_128469_(PRIMARY_INGREDIENT_INVENTORY));
            this.secondaryIngredientHandler.deserializeNBT(nbt.m_128469_(SECONDARY_INGREDIENT_INVENTORY));
            this.outputHandler.deserializeNBT(nbt.m_128469_(OUTPUT_INVENTORY));
            this.fluidInputHandler.deserializeNBT(nbt.m_128469_(FLUID_INPUT_INVENTORY));
        }
        this.fluidTank.readFromNBT(nbt);
        this.progress = nbt.m_128451_(PROGRESS);
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag nbt) {
        nbt.m_128365_(CRYSTAL_BASE_INVENTORY, (Tag)this.crystalBaseHandler.serializeNBT());
        nbt.m_128365_(PRIMARY_INGREDIENT_INVENTORY, (Tag)this.primaryIngredientHandler.serializeNBT());
        nbt.m_128365_(SECONDARY_INGREDIENT_INVENTORY, (Tag)this.secondaryIngredientHandler.serializeNBT());
        nbt.m_128365_(OUTPUT_INVENTORY, (Tag)this.outputHandler.serializeNBT());
        nbt.m_128365_(FLUID_INPUT_INVENTORY, (Tag)this.fluidInputHandler.serializeNBT());
        nbt = this.fluidTank.writeToNBT(nbt);
        nbt.m_128405_(PROGRESS, this.progress);
        super.m_183515_(nbt);
    }

    public abstract Fluid getDesiredFluid();

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, Direction side) {
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            return this.lazyFluidHandler.cast();
        }
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            if (side == Direction.UP) {
                return this.lazyCrystalBaseHandler.cast();
            }
            if (side == Direction.DOWN) {
                return this.lazyOutputHandler.cast();
            }
            if (side == this.getDirection().m_122427_()) {
                return this.lazyPrimaryIngredientHandler.cast();
            }
            if (side == this.getDirection().m_122428_()) {
                return this.lazySecondaryIngredientHandler.cast();
            }
            return this.lazyFluidInputHandler.cast();
        }
        return super.getCapability(capability, side);
    }

    public void setFluid(FluidStack fluidStack) {
        this.fluidTank.setFluid(fluidStack);
    }

    public FluidStack getFluid() {
        return this.fluidTank.getFluid();
    }

    private ItemStackHandler createCrystalBaseHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                AbstractCrystallizerEntity.this.m_6596_();
            }

            public int getSlotLimit(int slot) {
                return 64;
            }
        };
    }

    private ItemStackHandler createIngredientHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                AbstractCrystallizerEntity.this.m_6596_();
            }

            public int getSlotLimit(int slot) {
                return 64;
            }
        };
    }

    private ItemStackHandler createOutputHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                AbstractCrystallizerEntity.this.m_6596_();
            }

            public int getSlotLimit(int slot) {
                return 64;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return false;
            }

            @NotNull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    private ItemStackHandler createFluidInputHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                AbstractCrystallizerEntity.this.m_6596_();
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent();
            }

            @NotNull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @Nullable
    public Direction getDirection() {
        BlockPos gatePos = this.m_58899_();
        BlockState gateState = this.f_58857_.m_8055_(gatePos);
        if (gateState.m_60734_() instanceof AbstractCrystallizerBlock) {
            return (Direction)gateState.m_61143_((Property)AbstractCrystallizerBlock.f_54117_);
        }
        return Direction.NORTH;
    }

    public boolean hasFluidItem() {
        return this.fluidInputHandler.getStackInSlot(0).m_41613_() > 0;
    }

    public void fillFluidTank(FluidStack stack, ItemStack container) {
        this.fluidTank.fill(stack, IFluidHandler.FluidAction.EXECUTE);
        this.fluidInputHandler.extractItem(0, 1, false);
        this.fluidInputHandler.insertItem(0, container, false);
    }

    public void drainFluidFromItem() {
        this.fluidInputHandler.getStackInSlot(0).getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(handler -> {
            int drainAmount = Math.min(this.fluidTank.getSpace(), 1000);
            FluidStack stack = handler.getFluidInTank(0);
            if (this.fluidTank.isFluidValid(stack)) {
                stack = handler.drain(drainAmount, IFluidHandler.FluidAction.EXECUTE);
                this.fillFluidTank(stack, handler.getContainer());
            }
        });
    }

    public LazyOptional<IItemHandler> getItemHandler(int slot) {
        return switch (slot) {
            case 1 -> this.lazyPrimaryIngredientHandler;
            case 2 -> this.lazySecondaryIngredientHandler;
            case 3 -> this.lazyOutputHandler;
            case 4 -> this.lazyFluidInputHandler;
            default -> this.lazyCrystalBaseHandler;
        };
    }

    @Override
    protected long capacity() {
        return 0L;
    }

    @Override
    protected long maxReceive() {
        return 0L;
    }

    @Override
    protected long maxExtract() {
        return 0L;
    }

    protected static boolean hasSpaceInOutputSlot(SimpleContainer inventory, ItemStack stack) {
        if (inventory.m_8020_(3).m_41741_() <= inventory.m_8020_(3).m_41613_()) {
            return false;
        }
        return inventory.m_8020_(3).m_41720_() == stack.m_41720_() || inventory.m_8020_(3).m_41619_();
    }

    protected abstract boolean hasIngredients();

    protected abstract void crystallize();

    public static void tick(Level level, BlockPos pos, BlockState state, AbstractCrystallizerEntity crystallizer) {
        if (level.m_5776_()) {
            return;
        }
        if (crystallizer.hasFluidItem()) {
            crystallizer.drainFluidFromItem();
        }
        if (crystallizer.hasIngredients() && crystallizer.fluidTank.getFluidAmount() > 0) {
            ++crystallizer.progress;
            crystallizer.fluidTank.drain(1, IFluidHandler.FluidAction.EXECUTE);
            AbstractCrystallizerEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
            if (crystallizer.progress >= 200) {
                crystallizer.crystallize();
            }
        } else {
            crystallizer.progress = 0;
            AbstractCrystallizerEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(crystallizer.f_58858_)), (Object)new ClientboundCrystallizerUpdatePacket(crystallizer.f_58858_, crystallizer.getFluid(), crystallizer.progress));
    }
}

