/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.dhd;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemStackHandler;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.dhd.CrystalDHDEntity;
import net.povstalec.sgjourney.common.config.CommonDHDConfig;
import net.povstalec.sgjourney.common.config.CommonTechConfig;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.init.SoundInit;
import net.povstalec.sgjourney.common.items.energy_cores.FusionCoreItem;
import org.jetbrains.annotations.NotNull;

public class MilkyWayDHDEntity
extends CrystalDHDEntity {
    public MilkyWayDHDEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.MILKY_WAY_DHD.get(), pos, state);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        MilkyWayDHDEntity.addTransferCrystals(this.itemHandler);
        this.symbolInfo().setPointOfOrigin(new ResourceLocation(tag.m_128461_("point_of_origin")));
        this.symbolInfo().setSymbols(new ResourceLocation(tag.m_128461_("symbols")));
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_("point_of_origin", this.symbolInfo().pointOfOrigin().toString());
        tag.m_128359_("symbols", this.symbolInfo().symbols().toString());
    }

    @Override
    protected long buttonPressEnergyCost() {
        return (Long)CommonDHDConfig.milky_way_dhd_button_press_energy_cost.get();
    }

    @Override
    protected long capacity() {
        return (Long)CommonDHDConfig.milky_way_dhd_energy_buffer_capacity.get();
    }

    @Override
    protected long maxReceive() {
        return (Long)CommonDHDConfig.milky_way_dhd_max_energy_receive.get();
    }

    @Override
    public long maxEnergyDeplete() {
        return this.maxEnergyTransfer < 0 ? (Long)CommonDHDConfig.milky_way_dhd_max_energy_extract.get() : (long)this.maxEnergyTransfer;
    }

    @Override
    protected SoundEvent getEnterSound() {
        return (SoundEvent)SoundInit.MILKY_WAY_DHD_ENTER.get();
    }

    @Override
    protected SoundEvent getPressSound() {
        return (SoundEvent)SoundInit.MILKY_WAY_DHD_PRESS.get();
    }

    public static void addTransferCrystals(ItemStackHandler itemHandler) {
        int slots = itemHandler.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (!stack.m_150930_((Item)ItemInit.ENERGY_CRYSTAL.get()) || !stack.m_41782_() || !stack.m_41783_().m_128461_("CrystalMode").equals("ENERGY_TRANSFER")) continue;
            itemHandler.setStackInSlot(i, new ItemStack((ItemLike)ItemInit.TRANSFER_CRYSTAL.get()));
            StargateJourney.LOGGER.info("Replaced Transfer Crystal");
        }
    }

    @Override
    protected void generateEnergyCore() {
        this.energyItemHandler.setStackInSlot(0, FusionCoreItem.randomFusionCore((Integer)CommonTechConfig.fusion_core_fuel_capacity.get() / 3, (Integer)CommonTechConfig.fusion_core_fuel_capacity.get()));
    }

    @Override
    protected void generateCrystals() {
        this.itemHandler.setStackInSlot(0, new ItemStack((ItemLike)ItemInit.LARGE_CONTROL_CRYSTAL.get()));
        this.itemHandler.setStackInSlot(1, new ItemStack((ItemLike)ItemInit.ENERGY_CRYSTAL.get()));
        this.itemHandler.setStackInSlot(2, new ItemStack((ItemLike)ItemInit.COMMUNICATION_CRYSTAL.get()));
        this.itemHandler.setStackInSlot(3, new ItemStack((ItemLike)ItemInit.ENERGY_CRYSTAL.get()));
        this.itemHandler.setStackInSlot(5, new ItemStack((ItemLike)ItemInit.ENERGY_CRYSTAL.get()));
        this.itemHandler.setStackInSlot(7, new ItemStack((ItemLike)ItemInit.TRANSFER_CRYSTAL.get()));
    }
}

