/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.dhd;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.povstalec.sgjourney.common.block_entities.dhd.CrystalDHDEntity;
import net.povstalec.sgjourney.common.config.CommonDHDConfig;
import net.povstalec.sgjourney.common.config.CommonNaquadahGeneratorConfig;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.init.SoundInit;
import net.povstalec.sgjourney.common.items.CallForwardingDevice;
import net.povstalec.sgjourney.common.items.NaquadahFuelRodItem;
import net.povstalec.sgjourney.common.items.crystals.AbstractCrystalItem;

public class ClassicDHDEntity
extends CrystalDHDEntity {
    public ClassicDHDEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.CLASSIC_DHD.get(), pos, state);
    }

    @Override
    protected long buttonPressEnergyCost() {
        return (Long)CommonDHDConfig.classic_dhd_button_press_energy_cost.get();
    }

    @Override
    protected long capacity() {
        return (Long)CommonDHDConfig.classic_dhd_energy_buffer_capacity.get();
    }

    @Override
    protected long maxReceive() {
        return (Long)CommonDHDConfig.classic_dhd_max_energy_receive.get();
    }

    @Override
    public long maxEnergyDeplete() {
        return this.maxEnergyTransfer < 0 ? (Long)CommonDHDConfig.milky_way_dhd_max_energy_extract.get() : (long)this.maxEnergyTransfer;
    }

    @Override
    protected SoundEvent getEnterSound() {
        return (SoundEvent)SoundInit.CLASSIC_DHD_ENTER.get();
    }

    @Override
    protected SoundEvent getPressSound() {
        return (SoundEvent)SoundInit.CLASSIC_DHD_PRESS.get();
    }

    @Override
    protected boolean isValidCrystal(int slot, ItemStack stack) {
        AbstractCrystalItem crystal;
        if (slot == 0) {
            AbstractCrystalItem crystal2;
            Item item = stack.m_41720_();
            return item instanceof AbstractCrystalItem && (crystal2 = (AbstractCrystalItem)item).isLarge();
        }
        Item item = stack.m_41720_();
        return item instanceof AbstractCrystalItem && !(crystal = (AbstractCrystalItem)item).isAdvanced() || stack.m_41720_() instanceof CallForwardingDevice;
    }

    @Override
    protected void generateEnergyCore() {
        this.energyItemHandler.setStackInSlot(0, new ItemStack((ItemLike)ItemInit.NAQUADAH_GENERATOR_CORE.get()));
        this.energyItemHandler.setStackInSlot(1, NaquadahFuelRodItem.randomFuelRod((Integer)CommonNaquadahGeneratorConfig.naquadah_rod_max_fuel.get() / 2, (Integer)CommonNaquadahGeneratorConfig.naquadah_rod_max_fuel.get()));
    }

    @Override
    protected void generateCrystals() {
        this.itemHandler.setStackInSlot(0, new ItemStack((ItemLike)ItemInit.LARGE_CONTROL_CRYSTAL.get()));
        this.itemHandler.setStackInSlot(1, new ItemStack((ItemLike)ItemInit.ENERGY_CRYSTAL.get()));
        this.itemHandler.setStackInSlot(2, new ItemStack((ItemLike)ItemInit.COMMUNICATION_CRYSTAL.get()));
        this.itemHandler.setStackInSlot(3, new ItemStack((ItemLike)ItemInit.ENERGY_CRYSTAL.get()));
        this.itemHandler.setStackInSlot(5, new ItemStack((ItemLike)ItemInit.ENERGY_CRYSTAL.get()));
        this.itemHandler.setStackInSlot(7, new ItemStack((ItemLike)ItemInit.TRANSFER_CRYSTAL.get()));
    }
}

