/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.povstalec.sgjourney.client.Layers;
import net.povstalec.sgjourney.client.models.block_entity.TransportRingsModel;
import net.povstalec.sgjourney.common.block_entities.tech.TransportRingsEntity;

public class TransportRingsRenderer
implements BlockEntityRenderer<TransportRingsEntity> {
    protected final TransportRingsModel transportRings;

    public TransportRingsRenderer(BlockEntityRendererProvider.Context context) {
        this.transportRings = new TransportRingsModel(context.m_173582_(Layers.TRANSPORT_RING_LAYER));
    }

    private float getHeight(TransportRingsEntity rings, int ringNumber, float partialTick) {
        float ringHeight = 0.0f;
        int startTicks = 6 * (ringNumber - 1);
        float movingHeight = rings.getProgress(partialTick) - (float)(6 * (ringNumber - 1));
        int staticHeight = rings.getTransportHeight() - 2 * (ringNumber - 1);
        int stopHeight = rings.getTransportHeight() + 17 - 4 * (5 - ringNumber);
        if (rings.ticks == rings.progress && rings.progress > startTicks && rings.progress < stopHeight) {
            ringHeight = movingHeight * 4.0f;
        } else if (rings.progress >= stopHeight) {
            ringHeight = staticHeight * 4;
        } else if (rings.ticks != rings.progress && rings.progress > startTicks && rings.progress < stopHeight) {
            ringHeight = movingHeight * 4.0f;
        }
        if (rings.emptySpace > 0) {
            return ringHeight;
        }
        if (rings.emptySpace < 0) {
            return -ringHeight;
        }
        return 0.0f;
    }

    public void render(TransportRingsEntity rings, float partialTick, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        stack.m_85836_();
        stack.m_85837_(0.5, 0.5, 0.5);
        this.transportRings.setRingHeight(1, this.getHeight(rings, 1, partialTick));
        this.transportRings.setRingHeight(2, this.getHeight(rings, 2, partialTick));
        this.transportRings.setRingHeight(3, this.getHeight(rings, 3, partialTick));
        this.transportRings.setRingHeight(4, this.getHeight(rings, 4, partialTick));
        this.transportRings.setRingHeight(5, this.getHeight(rings, 5, partialTick));
        this.transportRings.renderTransportRings(rings, partialTick, stack, source, combinedLight, combinedOverlay);
        stack.m_85849_();
    }
}

