/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.models.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.povstalec.sgjourney.client.models.block_entity.GenericStargateModel;
import net.povstalec.sgjourney.client.render.SGJourneyRenderTypes;
import net.povstalec.sgjourney.client.resourcepack.stargate_variant.PegasusStargateVariant;
import net.povstalec.sgjourney.common.block_entities.stargate.PegasusStargateEntity;
import net.povstalec.sgjourney.common.misc.ColorUtil;
import net.povstalec.sgjourney.common.sgjourney.PointOfOrigin;
import net.povstalec.sgjourney.common.sgjourney.Symbols;

public class PegasusStargateModel
extends GenericStargateModel<PegasusStargateEntity, PegasusStargateVariant> {
    private static final int RED = 0;
    private static final int GREEN = 100;
    private static final int BLUE = 200;
    private static final int ENGAGED_GREEN = 200;
    private static final int ENGAGED_BLUE = 255;
    protected int currentSymbol = 0;

    public PegasusStargateModel() {
        super((short)36);
    }

    @Override
    public void renderStargate(PegasusStargateEntity stargate, PegasusStargateVariant stargateVariant, float partialTick, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        VertexConsumer consumer = source.m_6299_(SGJourneyRenderTypes.stargate(stargateVariant.texture()));
        this.renderOuterRing(stack, consumer, source, combinedLight);
        this.renderSymbolRing(stargate, stargateVariant, stack, consumer, source, combinedLight, 0.0f);
        this.renderChevrons(stargate, stargateVariant, stack, source, combinedLight, combinedOverlay);
    }

    public void setCurrentSymbol(int currentSymbol) {
        this.currentSymbol = currentSymbol;
    }

    protected void renderSpinningSymbol(PegasusStargateEntity stargate, PegasusStargateVariant stargateVariant, PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight, float symbolOffset, int textureXSize, float rotation) {
        if (!stargate.isConnected() && stargate.symbolBuffer < stargate.addressBuffer.getLength()) {
            for (int i = 0; i < stargate.getAddress().getLength(); ++i) {
                if (stargate.getChevronPosition(i + 1) != this.currentSymbol) continue;
                return;
            }
            this.renderSymbol(stargate, stargateVariant, stack, consumer, source, 0xF000F0, this.currentSymbol, symbolOffset, textureXSize, 0.0f, this.getSymbolColor(stargate, stargateVariant, true));
        }
    }

    @Override
    protected void renderSymbols(PegasusStargateEntity stargate, PegasusStargateVariant stargateVariant, PoseStack stack, VertexConsumer consumer, MultiBufferSource source, int combinedLight, float rotation) {
        Symbols symbols;
        int currentSymbol = stargate.addressBuffer.getSymbol(stargate.symbolBuffer);
        PointOfOrigin pointOfOrigin = this.getPointOfOrigin(stargate, stargateVariant);
        if (pointOfOrigin != null) {
            if (stargate.isDialingOut() && stargate.isConnected() || stargate.isConnected() && stargate.getKawooshTickCount() > 0) {
                consumer = source.m_6299_(SGJourneyRenderTypes.stargateRing(this.getPointOfOriginTexture(pointOfOrigin)));
                this.renderSymbol(stargate, stargateVariant, stack, consumer, source, 0xF000F0, 0, 0.5f, 1, rotation, this.getSymbolColor(stargate, stargateVariant, true));
            } else if (stargate.addressBuffer.getLength() > 0 && !stargate.isConnected() && currentSymbol == 0) {
                consumer = source.m_6299_(SGJourneyRenderTypes.stargateRing(this.getPointOfOriginTexture(pointOfOrigin)));
                this.renderSpinningSymbol(stargate, stargateVariant, stack, consumer, source, 0xF000F0, 0.5f, 1, rotation);
            } else if (!stargate.isConnected() && stargate.addressBuffer.getLength() == 0) {
                consumer = source.m_6299_(SGJourneyRenderTypes.stargateRing(this.getPointOfOriginTexture(pointOfOrigin)));
                this.renderSymbol(stargate, stargateVariant, stack, consumer, source, 0xF000F0, 0, 0.5f, 1, rotation, this.getSymbolColor(stargate, stargateVariant, false));
            }
        }
        if ((symbols = this.getSymbols(stargate, stargateVariant)) == null) {
            return;
        }
        consumer = source.m_6299_(SGJourneyRenderTypes.stargateRing(this.getSymbolTexture(symbols)));
        if (stargate.isDialingOut() && stargate.isConnected() || stargate.addressBuffer.getLength() > 0 && !stargate.isConnected()) {
            if (currentSymbol > 0) {
                this.renderSpinningSymbol(stargate, stargateVariant, stack, consumer, source, combinedLight, symbols.getTextureOffset(currentSymbol), symbols.getSize(), rotation);
            }
            for (int i = 0; i < stargate.getAddress().getLength(); ++i) {
                int symbolNumber = stargate.getChevronPosition(i + 1);
                this.renderSymbol(stargate, stargateVariant, stack, consumer, source, 0xF000F0, symbolNumber, symbols.getTextureOffset(stargate.getAddress().toArray()[i]), symbols.getSize(), 0.0f, this.getSymbolColor(stargate, stargateVariant, true));
            }
        } else {
            int startFrom;
            ColorUtil.RGBA symbolColor = this.getSymbolColor(stargate, stargateVariant, false);
            int symbolNumber = this.numberOfSymbols;
            if (stargate.isConnected()) {
                symbolColor = this.getSymbolColor(stargate, stargateVariant, true);
                symbolNumber = stargate.currentSymbol < this.numberOfSymbols ? stargate.currentSymbol : symbolNumber;
            }
            for (int i = startFrom = stargate.isConnected() ? 0 : 1; i < symbolNumber; ++i) {
                int renderedSymbol = (stargate.isConnected() ? i + 1 : i) % this.numberOfSymbols;
                this.renderSymbol(stargate, stargateVariant, stack, consumer, source, 0xF000F0, renderedSymbol, symbols.getTextureOffset(renderedSymbol), symbols.getSize(), 0.0f, symbolColor);
            }
        }
    }
}

