/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.mixin;

import com.starfish_studios.naturalist.NaturalistConfig;
import com.starfish_studios.naturalist.common.entity.Firefly;
import com.starfish_studios.naturalist.core.registry.NaturalistTags;
import java.util.logging.Logger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Mob.class})
public abstract class MobMixin
extends LivingEntity {
    @Unique
    private static final Logger naturalist$LOGGER = Logger.getLogger("Naturalist");

    protected MobMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"doHurtTarget"}, at={@At(value="HEAD")})
    private void naturalist$onDoHurtTarget(Entity entity, CallbackInfoReturnable<Boolean> cir) {
        if (BuiltInRegistries.f_256780_.m_7981_((Object)this.m_6095_()).equals((Object)BuiltInRegistries.f_256780_.m_7981_((Object)EntityType.f_217012_)) && entity instanceof Firefly) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 60));
        }
    }

    @Inject(method={"checkDespawn"}, at={@At(value="HEAD")}, cancellable=true)
    private void naturalist$checkDespawnMixin(CallbackInfo ci) {
        if (!this.m_6095_().m_204039_(NaturalistTags.EntityTypes.NATURALIST_ENTITIES)) {
            return;
        }
        if (BuiltInRegistries.f_256780_.m_7981_((Object)this.m_6095_()).m_135815_().equals("caterpillar")) {
            return;
        }
        String mobName = this.naturalist$toCamelCase(BuiltInRegistries.f_256780_.m_7981_((Object)this.m_6095_()).m_135815_());
        String configFieldName = mobName + "Removed";
        try {
            boolean animalRemoved = NaturalistConfig.class.getField(configFieldName).getBoolean(null);
            if (animalRemoved) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                ci.cancel();
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            System.err.println("Failed to check despawn config for mob '" + mobName + "': " + configFieldName);
            e.printStackTrace();
        }
    }

    @Unique
    private String naturalist$toCamelCase(String input) {
        StringBuilder camelCase = new StringBuilder();
        boolean capitalizeNext = false;
        for (char c : input.toCharArray()) {
            if (c == '_') {
                capitalizeNext = true;
                continue;
            }
            camelCase.append(capitalizeNext ? Character.toUpperCase(c) : c);
            capitalizeNext = false;
        }
        return camelCase.toString();
    }
}

