/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.item.forge;

import com.starfish_studios.naturalist.common.entity.Butterfly;
import com.starfish_studios.naturalist.common.entity.core.Catchable;
import com.starfish_studios.naturalist.core.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.item.forge.NoFluidMobBucketItem;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaughtMobItem
extends NoFluidMobBucketItem {
    private final Supplier<? extends EntityType<?>> typeSup;

    private EntityType<?> type() {
        return this.typeSup.get();
    }

    public CaughtMobItem(Supplier<? extends EntityType<?>> entitySupplier, Supplier<? extends Fluid> fluidSupplier, Supplier<? extends SoundEvent> soundSupplier, Item.Properties properties) {
        super(entitySupplier, fluidSupplier, soundSupplier, properties);
        this.typeSup = entitySupplier;
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag compoundnbt;
        if (this.type() == NaturalistEntityTypes.BUTTERFLY.get() && (compoundnbt = stack.m_41783_()) != null && compoundnbt.m_128425_("Variant", 3)) {
            Butterfly.Variant variant = Butterfly.Variant.getTypeById(compoundnbt.m_128451_("Variant"));
            tooltip.add((Component)Component.m_237115_((String)String.format("tooltip.naturalist.%s", variant.toString().toLowerCase())).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        }
    }

    private void spawn(ServerLevel serverLevel, ItemStack itemStack, BlockPos pos) {
        Entity entity = this.type().m_20592_(serverLevel, itemStack, null, pos, MobSpawnType.BUCKET, true, false);
        if (entity instanceof Catchable) {
            Catchable catchable = (Catchable)entity;
            catchable.loadFromHandTag(itemStack.m_41784_());
            catchable.setFromHand(true);
        }
    }

    public void m_142131_(@Nullable Player player, Level level, ItemStack containerStack, BlockPos pos) {
        if (level instanceof ServerLevel) {
            this.spawn((ServerLevel)level, containerStack, pos);
            level.m_142346_((Entity)player, GameEvent.f_157810_, pos);
        }
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        BlockHitResult blockhitresult;
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        InteractionResultHolder ret = ForgeEventFactory.onBucketUse((Player)pPlayer, (Level)pLevel, (ItemStack)itemstack, (HitResult)(blockhitresult = CaughtMobItem.m_41435_((Level)pLevel, (Player)pPlayer, (ClipContext.Fluid)ClipContext.Fluid.NONE)));
        if (ret != null) {
            return ret;
        }
        if (blockhitresult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        if (blockhitresult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        BlockPos pos = blockhitresult.m_82425_();
        Direction direction = blockhitresult.m_82434_();
        BlockPos blockpos1 = pos.m_121945_(direction);
        if (pLevel.m_7966_(pPlayer, pos) && pPlayer.m_36204_(blockpos1, direction, itemstack)) {
            this.m_142131_(pPlayer, pLevel, itemstack, pos);
            this.m_7718_(pPlayer, (LevelAccessor)pLevel, pos);
            pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)CaughtMobItem.getEmptySuccessItem(itemstack, pPlayer), (boolean)pLevel.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    @NotNull
    public static ItemStack getEmptySuccessItem(ItemStack bucketStack, Player player) {
        return !player.m_150110_().f_35937_ ? new ItemStack((ItemLike)Items.f_41852_) : bucketStack;
    }
}

