/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.common.entity.core.ai.navigation;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.BodyRotationControl;

public class SmartBodyHelper
extends BodyRotationControl {
    private static final int HISTORY_SIZE = 10;
    private static final double MOVE_THRESHOLD = 2.5E-7;
    public float bodyLagMoving;
    public float headLag;
    public float bodyLagStill;
    public float bodyMax;
    public float headMax;
    private final double[] histPosX = new double[10];
    private final double[] histPosZ = new double[10];
    protected final Mob entity;

    public SmartBodyHelper(Mob entity) {
        super(entity);
        this.entity = entity;
        this.bodyLagMoving = 0.3f;
        this.headLag = 0.2f;
        this.bodyLagStill = 0.05f;
        this.bodyMax = 45.0f;
        this.headMax = 22.5f;
    }

    public void m_8121_() {
        for (int i = 9; i > 0; --i) {
            this.histPosX[i] = this.histPosX[i - 1];
            this.histPosZ[i] = this.histPosZ[i - 1];
        }
        this.histPosX[0] = this.entity.m_20185_();
        this.histPosZ[0] = this.entity.m_20189_();
        double dx = this.avgDelta(this.histPosX);
        double dz = this.avgDelta(this.histPosZ);
        double distSq = dx * dx + dz * dz;
        if (this.entity.m_5448_() != null) {
            double tx = this.entity.m_5448_().m_20185_() - this.entity.m_20185_();
            double tz = this.entity.m_5448_().m_20189_() - this.entity.m_20189_();
            float targetAngle = (float)(Mth.m_14136_((double)tz, (double)tx) * 57.29577951308232) - 90.0f;
            this.entity.f_20883_ = this.approachAngle(this.entity.f_20883_, targetAngle, this.bodyLagMoving, this.bodyMax);
            this.entity.f_20885_ = this.approachAngle(this.entity.f_20885_, targetAngle, this.headLag, this.headMax);
            this.clampHeadBodyDifference();
        } else if (distSq > 2.5E-7) {
            float moveAngle = (float)(Math.toDegrees(Math.atan2(dz, dx)) - 90.0);
            this.entity.f_20883_ = this.approachAngle(this.entity.f_20883_, moveAngle, this.bodyLagMoving, this.bodyMax);
            this.entity.f_20885_ = this.approachAngle(this.entity.f_20885_, this.entity.f_20883_, this.headLag, this.headMax);
            this.clampHeadBodyDifference();
        } else {
            this.entity.f_20883_ = this.approachAngle(this.entity.f_20883_, this.entity.f_20885_, this.bodyLagStill, this.bodyMax);
            this.clampHeadBodyDifference();
        }
    }

    private double avgDelta(double[] arr) {
        return this.mean(arr, 0) - this.mean(arr, 5);
    }

    private double mean(double[] arr, int start) {
        double s = 0.0;
        int half = 5;
        for (int i = 0; i < half; ++i) {
            s += arr[start + i];
        }
        return s / (double)half;
    }

    private float approachAngle(float current, float target, float factor, float maxDelta) {
        float d = Mth.m_14177_((float)(target - current));
        if (d < -maxDelta) {
            d = -maxDelta;
        } else if (d > maxDelta) {
            d = maxDelta;
        }
        return current + d * factor;
    }

    private void clampHeadBodyDifference() {
        float diff = Mth.m_14177_((float)(this.entity.f_20885_ - this.entity.f_20883_));
        float clamped = Mth.m_14036_((float)diff, (float)(-this.headMax), (float)this.headMax);
        this.entity.f_20885_ = this.entity.f_20883_ + clamped;
    }
}

