/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.common.entity;

import com.starfish_studios.naturalist.common.entity.core.NaturalistGeoEntity;
import com.starfish_studios.naturalist.core.registry.NaturalistRegistry;
import com.starfish_studios.naturalist.core.registry.NaturalistSoundEvents;
import com.starfish_studios.naturalist.core.registry.NaturalistTags;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Catfish
extends AbstractFish
implements NaturalistGeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> KILL_COOLDOWN = SynchedEntityData.m_135353_(Catfish.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final RawAnimation SWIM = RawAnimation.begin().thenLoop("animation.sf_nba.catfish.swim");
    protected static final RawAnimation FLOP = RawAnimation.begin().thenLoop("animation.sf_nba.catfish.flop");

    public Catfish(EntityType<? extends AbstractFish> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22281_, 1.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false){

            public boolean m_8036_() {
                return super.m_8036_() && !Catfish.this.m_6162_() && Catfish.this.getKillCooldown() == 0;
            }

            public void m_8041_() {
                super.m_8041_();
                Catfish.this.setKillCooldown(2400);
            }
        });
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, WaterAnimal.class, 10, true, false, entity -> entity.m_6095_().m_204039_(NaturalistTags.EntityTypes.CATFISH_HOSTILES)));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(KILL_COOLDOWN, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("KillCooldown", this.getKillCooldown());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setKillCooldown(compound.m_128451_("KillCooldown"));
    }

    public void setKillCooldown(int ticks) {
        this.f_19804_.m_135381_(KILL_COOLDOWN, (Object)ticks);
    }

    public int getKillCooldown() {
        return (Integer)this.f_19804_.m_135370_(KILL_COOLDOWN);
    }

    protected SoundEvent m_5699_() {
        return NaturalistSoundEvents.CATFISH_FLOP.get();
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12327_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12328_;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12330_;
    }

    @NotNull
    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)NaturalistRegistry.CATFISH_BUCKET.get());
    }

    @Override
    public double getBoneResetTime() {
        return 2.0;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @NotNull
    protected <E extends Catfish> PlayState predicate(AnimationState<E> event) {
        if (!this.m_20069_()) {
            event.getController().setAnimation(FLOP);
        } else {
            event.getController().setAnimation(SWIM);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }
}

