/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute.attributes;

import com.simibubi.create.content.logistics.item.filter.attribute.AllItemAttributeTypes;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import org.jetbrains.annotations.NotNull;

public class ShulkerFillLevelAttribute
implements ItemAttribute {
    private ShulkerLevels levels;

    public ShulkerFillLevelAttribute(ShulkerLevels levels) {
        this.levels = levels;
    }

    @Override
    public boolean appliesTo(ItemStack stack, Level level) {
        return this.levels != null && this.levels.canApply(stack);
    }

    @Override
    public String getTranslationKey() {
        return "shulker_level";
    }

    @Override
    public Object[] getTranslationParameters() {
        String parameter = "";
        if (this.levels != null) {
            parameter = CreateLang.translateDirect("item_attributes." + this.getTranslationKey() + "." + this.levels.key, new Object[0]).getString();
        }
        return new Object[]{parameter};
    }

    @Override
    public ItemAttributeType getType() {
        return AllItemAttributeTypes.SHULKER_FILL_LEVEL;
    }

    @Override
    public void save(CompoundTag nbt) {
        if (this.levels != null) {
            nbt.m_128359_("level", this.levels.key);
        }
    }

    @Override
    public void load(CompoundTag nbt) {
        if (nbt.m_128441_("level")) {
            this.levels = ShulkerLevels.fromKey(nbt.m_128461_("level"));
        }
    }

    public static enum ShulkerLevels {
        EMPTY("empty", amount -> amount == 0),
        PARTIAL("partial", amount -> amount > 0 && amount < Integer.MAX_VALUE),
        FULL("full", amount -> amount == Integer.MAX_VALUE);

        private final Predicate<Integer> requiredSize;
        private final String key;

        private ShulkerLevels(String key, Predicate<Integer> requiredSize) {
            this.key = key;
            this.requiredSize = requiredSize;
        }

        @Nullable
        public static ShulkerLevels fromKey(String key) {
            return Arrays.stream(ShulkerLevels.values()).filter(shulkerLevels -> shulkerLevels.key.equals(key)).findFirst().orElse(null);
        }

        private static boolean isShulker(ItemStack stack) {
            return Block.m_49814_((Item)stack.m_41720_()) instanceof ShulkerBoxBlock;
        }

        public boolean canApply(ItemStack testStack) {
            if (!ShulkerLevels.isShulker(testStack)) {
                return false;
            }
            CompoundTag compoundnbt = testStack.m_41737_("BlockEntityTag");
            if (compoundnbt == null) {
                return this.requiredSize.test(0);
            }
            if (compoundnbt.m_128425_("LootTable", 8)) {
                return false;
            }
            if (compoundnbt.m_128425_("Items", 9)) {
                int rawSize = compoundnbt.m_128437_("Items", 10).size();
                if (rawSize < 27) {
                    return this.requiredSize.test(rawSize);
                }
                NonNullList inventory = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
                ContainerHelper.m_18980_((CompoundTag)compoundnbt, (NonNullList)inventory);
                boolean isFull = inventory.stream().allMatch(itemStack -> !itemStack.m_41619_() && itemStack.m_41613_() == itemStack.m_41741_());
                return this.requiredSize.test(isFull ? Integer.MAX_VALUE : rawSize);
            }
            return this.requiredSize.test(0);
        }
    }

    public static class Type
    implements ItemAttributeType {
        @Override
        @NotNull
        public ItemAttribute createAttribute() {
            return new ShulkerFillLevelAttribute(null);
        }

        @Override
        public List<ItemAttribute> getAllAttributes(ItemStack stack, Level level) {
            ArrayList<ItemAttribute> list = new ArrayList<ItemAttribute>();
            for (ShulkerLevels shulkerLevels : ShulkerLevels.values()) {
                if (!shulkerLevels.canApply(stack)) continue;
                list.add(new ShulkerFillLevelAttribute(shulkerLevels));
            }
            return list;
        }
    }
}

