/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.armor;

import com.simibubi.create.AllItems;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CardboardArmorHandler {
    @SubscribeEvent
    public static void playerHitboxChangesWhenHidingAsBox(EntityEvent.Size event) {
        Entity entity = event.getEntity();
        if (!entity.isAddedToWorld()) {
            return;
        }
        if (!CardboardArmorHandler.testForStealth(entity)) {
            return;
        }
        event.setNewSize(EntityDimensions.m_20398_((float)0.6f, (float)0.8f));
        event.setNewEyeHeight(0.6f);
        if (!entity.m_9236_().m_5776_() && entity instanceof Player) {
            Player p = (Player)entity;
            AllAdvancements.CARDBOARD_ARMOR.awardTo(p);
        }
    }

    @SubscribeEvent
    public static void playersStealthWhenWearingCardboard(LivingEvent.LivingVisibilityEvent event) {
        LivingEntity entity = event.getEntity();
        if (!CardboardArmorHandler.testForStealth((Entity)entity)) {
            return;
        }
        event.modifyVisibility(0.0);
    }

    @SubscribeEvent
    public static void mobsMayLoseTargetWhenItIsWearingCardboard(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.f_19797_ % 16 != 0) {
            return;
        }
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        if (CardboardArmorHandler.testForStealth((Entity)mob.m_5448_())) {
            mob.m_6710_(null);
            if (mob.f_21346_ != null) {
                mob.f_21346_.m_25386_().forEach(wrappedGoal -> {
                    Goal patt2140$temp = wrappedGoal.m_26015_();
                    if (patt2140$temp instanceof TargetGoal) {
                        TargetGoal tg = (TargetGoal)patt2140$temp;
                        tg.m_8041_();
                    }
                });
            }
        }
        if (entity instanceof NeutralMob) {
            NeutralMob nMob = (NeutralMob)entity;
            Level level = entity.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                UUID uuid = nMob.m_6120_();
                if (uuid != null && CardboardArmorHandler.testForStealth(sl.m_8791_(uuid))) {
                    nMob.m_21662_();
                }
            }
        }
        if (CardboardArmorHandler.testForStealth((Entity)mob.m_21188_())) {
            mob.m_6703_(null);
            mob.m_6598_(null);
        }
    }

    public static boolean testForStealth(Entity entityIn) {
        if (!(entityIn instanceof LivingEntity)) {
            return false;
        }
        LivingEntity entity = (LivingEntity)entityIn;
        if (entity.m_20089_() != Pose.CROUCHING) {
            return false;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_150110_().f_35935_) {
                return false;
            }
        }
        if (!AllItems.CARDBOARD_HELMET.isIn(entity.m_6844_(EquipmentSlot.HEAD))) {
            return false;
        }
        if (!AllItems.CARDBOARD_CHESTPLATE.isIn(entity.m_6844_(EquipmentSlot.CHEST))) {
            return false;
        }
        if (!AllItems.CARDBOARD_LEGGINGS.isIn(entity.m_6844_(EquipmentSlot.LEGS))) {
            return false;
        }
        return AllItems.CARDBOARD_BOOTS.isIn(entity.m_6844_(EquipmentSlot.FEET));
    }
}

