/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot.chemical;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.recipes.ItemStackToGasRecipe;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.inventory.slot.chemical.ChemicalInventorySlot;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class GasInventorySlot
extends ChemicalInventorySlot<Gas, GasStack> {
    @Nullable
    public static IGasHandler getCapability(ItemStack stack) {
        return GasInventorySlot.getCapability(stack, Capabilities.GAS_HANDLER);
    }

    private static GasStack getPotentialConversion(@Nullable Level world, ItemStack itemStack) {
        return GasInventorySlot.getPotentialConversion(MekanismRecipeType.GAS_CONVERSION, world, itemStack, GasStack.EMPTY);
    }

    public static GasInventorySlot rotaryDrain(IGasTank gasTank, BooleanSupplier modeSupplier, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(gasTank, "Gas tank cannot be null");
        Objects.requireNonNull(modeSupplier, "Mode supplier cannot be null");
        Predicate<@NotNull ItemStack> insertPredicate = GasInventorySlot.getDrainInsertPredicate(gasTank, GasInventorySlot::getCapability).and(stack -> modeSupplier.getAsBoolean());
        return new GasInventorySlot(gasTank, insertPredicate.negate(), insertPredicate, stack -> stack.getCapability(Capabilities.GAS_HANDLER).isPresent(), listener, x, y);
    }

    public static GasInventorySlot rotaryFill(IGasTank gasTank, BooleanSupplier modeSupplier, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(gasTank, "Gas tank cannot be null");
        Objects.requireNonNull(modeSupplier, "Mode supplier cannot be null");
        return new GasInventorySlot(gasTank, GasInventorySlot.getFillExtractPredicate(gasTank, GasInventorySlot::getCapability), stack -> !modeSupplier.getAsBoolean() && GasInventorySlot.fillInsertCheck(gasTank, GasInventorySlot.getCapability(stack)), stack -> stack.getCapability(Capabilities.GAS_HANDLER).isPresent(), listener, x, y);
    }

    public static GasInventorySlot fillOrConvert(IGasTank gasTank, Supplier<Level> worldSupplier, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(gasTank, "Gas tank cannot be null");
        Objects.requireNonNull(worldSupplier, "World supplier cannot be null");
        Function<ItemStack, GasStack> potentialConversionSupplier = stack -> GasInventorySlot.getPotentialConversion((Level)worldSupplier.get(), stack);
        return new GasInventorySlot(gasTank, worldSupplier, GasInventorySlot.getFillOrConvertExtractPredicate(gasTank, GasInventorySlot::getCapability, potentialConversionSupplier), GasInventorySlot.getFillOrConvertInsertPredicate(gasTank, GasInventorySlot::getCapability, potentialConversionSupplier), stack -> {
            if (stack.getCapability(Capabilities.GAS_HANDLER).isPresent()) {
                return true;
            }
            GasStack gasConversion = GasInventorySlot.getPotentialConversion((Level)worldSupplier.get(), stack);
            return !gasConversion.isEmpty() && gasTank.isValid(gasConversion);
        }, listener, x, y);
    }

    public static GasInventorySlot fill(IGasTank gasTank, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(gasTank, "Gas tank cannot be null");
        return new GasInventorySlot(gasTank, GasInventorySlot.getFillExtractPredicate(gasTank, GasInventorySlot::getCapability), stack -> GasInventorySlot.fillInsertCheck(gasTank, GasInventorySlot.getCapability(stack)), stack -> stack.getCapability(Capabilities.GAS_HANDLER).isPresent(), listener, x, y);
    }

    public static GasInventorySlot drain(IGasTank gasTank, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(gasTank, "Gas tank cannot be null");
        Predicate<@NotNull ItemStack> insertPredicate = GasInventorySlot.getDrainInsertPredicate(gasTank, GasInventorySlot::getCapability);
        return new GasInventorySlot(gasTank, insertPredicate.negate(), insertPredicate, stack -> stack.getCapability(Capabilities.GAS_HANDLER).isPresent(), listener, x, y);
    }

    private GasInventorySlot(IGasTank gasTank, Predicate<@NotNull ItemStack> canExtract, Predicate<@NotNull ItemStack> canInsert, Predicate<@NotNull ItemStack> validator, @Nullable IContentsListener listener, int x, int y) {
        this(gasTank, () -> null, canExtract, canInsert, validator, listener, x, y);
    }

    private GasInventorySlot(IGasTank gasTank, Supplier<Level> worldSupplier, Predicate<@NotNull ItemStack> canExtract, Predicate<@NotNull ItemStack> canInsert, Predicate<@NotNull ItemStack> validator, @Nullable IContentsListener listener, int x, int y) {
        super(gasTank, worldSupplier, canExtract, canInsert, validator, listener, x, y);
    }

    @Override
    @Nullable
    protected IChemicalHandler<Gas, GasStack> getCapability() {
        return GasInventorySlot.getCapability(this.current);
    }

    @Nullable
    protected ItemStackToGasRecipe getConversionRecipe(@Nullable Level world, ItemStack stack) {
        return (ItemStackToGasRecipe)((InputRecipeCache.SingleItem)MekanismRecipeType.GAS_CONVERSION.getInputCache()).findFirstRecipe(world, stack);
    }
}

