/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.forge.config;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.config.AbstractBalmConfig;
import net.blay09.mods.balm.api.config.BalmConfigData;
import net.blay09.mods.balm.api.config.Comment;
import net.blay09.mods.balm.api.config.ExpectedType;
import net.blay09.mods.balm.api.event.ConfigReloadedEvent;
import net.blay09.mods.balm.api.network.ConfigReflection;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ForgeBalmConfig
extends AbstractBalmConfig {
    private final Logger logger = LogManager.getLogger();
    private final Map<Class<?>, ModConfig> configs = new HashMap();
    private final Multimap<String, Class<?>> configsByMod = ArrayListMultimap.create();
    private final Map<Class<?>, BalmConfigData> configData = new HashMap();

    private <T extends BalmConfigData> IConfigSpec<?> createConfigSpec(Class<T> clazz) {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        try {
            this.buildConfigSpec("", builder, clazz);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Config spec generation unexpectedly failed.", e);
        }
        return builder.build();
    }

    private void buildConfigSpec(String parentPath, ForgeConfigSpec.Builder builder, Class<?> clazz) throws IllegalAccessException {
        List<Field> fields = ConfigReflection.getAllFields(clazz);
        Object defaults = this.createConfigDataInstance(clazz);
        for (Field field : fields) {
            Class<?> type = field.getType();
            Object defaultValue = field.get(defaults);
            String path = parentPath + field.getName();
            Comment comment = field.getAnnotation(Comment.class);
            if (comment != null) {
                builder.comment(comment.value());
            }
            if (String.class.isAssignableFrom(type)) {
                builder.define(path, (Object)((String)defaultValue));
                continue;
            }
            if (List.class.isAssignableFrom(type)) {
                ExpectedType expectedType = field.getAnnotation(ExpectedType.class);
                if (expectedType == null) {
                    this.logger.warn("Config field without expected type, will not validate list content ({} in {})", (Object)field.getName(), (Object)clazz.getName());
                }
                builder.defineListAllowEmpty(Arrays.asList(path.split("\\.")), () -> (List)defaultValue, it -> expectedType == null || expectedType.value().isAssignableFrom(it.getClass()) || expectedType.value().isEnum() && Arrays.stream(expectedType.value().getEnumConstants()).anyMatch(constant -> constant.toString().equals(it)));
                continue;
            }
            if (Enum.class.isAssignableFrom(type)) {
                builder.defineEnum(path, (Enum)defaultValue);
                continue;
            }
            if (Integer.TYPE.isAssignableFrom(type)) {
                builder.defineInRange(path, ((Integer)defaultValue).intValue(), Integer.MIN_VALUE, Integer.MAX_VALUE);
                continue;
            }
            if (Float.TYPE.isAssignableFrom(type)) {
                builder.defineInRange(path, (double)((Float)defaultValue).floatValue(), -3.4028234663852886E38, 3.4028234663852886E38);
                continue;
            }
            if (Double.TYPE.isAssignableFrom(type)) {
                builder.defineInRange(path, ((Double)defaultValue).doubleValue(), -1.7976931348623157E308, Double.MAX_VALUE);
                continue;
            }
            if (Boolean.TYPE.isAssignableFrom(type)) {
                builder.define(path, ((Boolean)defaultValue).booleanValue());
                continue;
            }
            if (Long.TYPE.isAssignableFrom(type)) {
                builder.defineInRange(path, ((Long)defaultValue).longValue(), Long.MIN_VALUE, Long.MAX_VALUE);
                continue;
            }
            this.buildConfigSpec(path + ".", builder, type);
        }
    }

    private <T extends BalmConfigData> T readConfigValues(Class<T> clazz, ModConfig config) {
        BalmConfigData instance = (BalmConfigData)this.createConfigDataInstance(clazz);
        try {
            this.readConfigValues("", instance, config);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return (T)instance;
    }

    private <T> void readConfigValues(String parentPath, T instance, ModConfig config) throws IllegalAccessException {
        List<Field> fields = ConfigReflection.getAllFields(instance.getClass());
        for (Field field : fields) {
            String path = parentPath + field.getName();
            boolean hasValue = config.getConfigData().contains(path);
            Class<?> type = field.getType();
            try {
                Integer integerValue;
                Float floatValue;
                Double doubleValue;
                Object value;
                if (hasValue && Integer.TYPE.isAssignableFrom(type)) {
                    field.set(instance, config.getConfigData().getInt(path));
                    continue;
                }
                if (hasValue && Long.TYPE.isAssignableFrom(type)) {
                    field.set(instance, config.getConfigData().getLong(path));
                    continue;
                }
                if (hasValue && Float.TYPE.isAssignableFrom(type)) {
                    value = config.getConfigData().get(path);
                    if (value instanceof Double) {
                        doubleValue = (Double)value;
                        field.set(instance, Float.valueOf(doubleValue.floatValue()));
                        continue;
                    }
                    if (value instanceof Float) {
                        floatValue = (Float)value;
                        field.set(instance, floatValue);
                        continue;
                    }
                    if (value instanceof Integer) {
                        integerValue = (Integer)value;
                        field.set(instance, Float.valueOf(integerValue.floatValue()));
                        continue;
                    }
                    this.logger.error("Invalid config value for " + path + ", expected " + type.getName() + " but got " + String.valueOf(value.getClass()));
                    continue;
                }
                if (hasValue && Double.TYPE.isAssignableFrom(type)) {
                    value = config.getConfigData().get(path);
                    if (value instanceof Double) {
                        doubleValue = (Double)value;
                        field.set(instance, doubleValue);
                        continue;
                    }
                    if (value instanceof Float) {
                        floatValue = (Float)value;
                        field.set(instance, floatValue.doubleValue());
                        continue;
                    }
                    if (value instanceof Integer) {
                        integerValue = (Integer)value;
                        field.set(instance, integerValue.doubleValue());
                        continue;
                    }
                    this.logger.error("Invalid config value for " + path + ", expected " + type.getName() + " but got " + String.valueOf(value.getClass()));
                    continue;
                }
                if (hasValue && (type.isPrimitive() || String.class.isAssignableFrom(type) || List.class.isAssignableFrom(type))) {
                    Object raw = config.getConfigData().getRaw(path);
                    if (raw != null) {
                        try {
                            field.set(instance, raw);
                        }
                        catch (IllegalArgumentException e) {
                            this.logger.error("Invalid config value for " + path + ", expected " + type.getName() + " but got " + String.valueOf(raw.getClass()));
                        }
                        continue;
                    }
                    this.logger.error("Null config value for " + path + ", falling back to default");
                    continue;
                }
                if (hasValue && type.isEnum()) {
                    value = config.getConfigData().getEnum(path, type);
                    field.set(instance, value);
                    continue;
                }
                this.readConfigValues(path + ".", field.get(instance), config);
            }
            catch (Exception e) {
                this.logger.error("Unexpected error loading config value for " + path + ", falling back to default", (Throwable)e);
            }
        }
    }

    private <T extends BalmConfigData> void writeConfigValues(ModConfig config, T configData) {
        try {
            this.writeConfigValues("", config, configData);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private <T> void writeConfigValues(String parentPath, ModConfig config, T instance) throws IllegalAccessException {
        List<Field> fields = ConfigReflection.getAllFields(instance.getClass());
        for (Field field : fields) {
            String path = parentPath + field.getName();
            Class<?> type = field.getType();
            Object value = field.get(instance);
            if (type.isPrimitive() || Enum.class.isAssignableFrom(type) || String.class.isAssignableFrom(type) || List.class.isAssignableFrom(type)) {
                config.getConfigData().set(path, value);
                continue;
            }
            this.writeConfigValues(path + ".", config, field.get(instance));
        }
    }

    @Override
    public <T extends BalmConfigData> T initializeBackingConfig(Class<T> clazz) {
        IConfigSpec<?> configSpec = this.createConfigSpec(clazz);
        BalmConfigData initialData = (BalmConfigData)this.createConfigDataInstance(clazz);
        this.setActiveConfig(clazz, initialData);
        this.configData.put(clazz, initialData);
        this.configsByMod.put((Object)this.getConfigName(clazz), clazz);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> {
            this.configs.put(clazz, event.getConfig());
            Object newConfigData = this.readConfigValues(clazz, event.getConfig());
            this.configData.put(clazz, (BalmConfigData)newConfigData);
            this.setActiveConfig(clazz, newConfigData);
        });
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> {
            this.configs.put(clazz, event.getConfig());
            Object newConfigData = this.readConfigValues(clazz, event.getConfig());
            this.configData.put(clazz, (BalmConfigData)newConfigData);
            boolean hasSyncMessage = this.getConfigSyncMessageFactory(clazz) != null;
            boolean isHostingServer = ServerLifecycleHooks.getCurrentServer() != null;
            boolean isIngame = (Boolean)DistExecutor.runForDist(() -> () -> Minecraft.m_91087_().f_91072_ != null, () -> () -> false);
            if (!hasSyncMessage || isHostingServer || !isIngame) {
                this.setActiveConfig(clazz, newConfigData);
            }
            Balm.getEvents().fireEvent(new ConfigReloadedEvent());
        });
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, configSpec);
        return this.getActive(clazz);
    }

    @Override
    public <T extends BalmConfigData> T getBackingConfig(Class<T> clazz) {
        return (T)this.configData.get(clazz);
    }

    @Override
    public <T extends BalmConfigData> void saveBackingConfig(Class<T> clazz) {
        ModConfig modConfig = this.configs.get(clazz);
        if (modConfig != null) {
            this.writeConfigValues(modConfig, this.configData.get(clazz));
            modConfig.save();
        }
    }

    @Override
    public File getConfigDir() {
        return FMLPaths.CONFIGDIR.get().toFile();
    }

    @Override
    public List<? extends BalmConfigData> getConfigsByMod(String modId) {
        return this.configsByMod.get((Object)modId).stream().map(this.configData::get).toList();
    }
}

