/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.block.provider;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import xiroc.dungeoncrawl.dungeon.block.provider.BlockStateProvider;
import xiroc.dungeoncrawl.util.JSONUtils;
import xiroc.dungeoncrawl.util.WeightedRandom;

public class WeightedRandomBlock
implements BlockStateProvider {
    protected static final String TYPE = "random_block";
    private final WeightedRandom<BlockState> randomBlockState;

    public WeightedRandomBlock(WeightedRandom<BlockState> randomBlockState) {
        this.randomBlockState = randomBlockState;
    }

    @Override
    public BlockState get(LevelAccessor world, BlockPos pos, RandomSource random, Rotation rotation) {
        return this.randomBlockState.roll(random);
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        object.addProperty("type", TYPE);
        JsonArray blocks = new JsonArray();
        this.randomBlockState.getEntries().forEach(entry -> {
            JsonObject block = JSONUtils.serializeBlockState(new JsonObject(), (BlockState)entry.m_14418_());
            block.addProperty("weight", (Number)entry.m_14419_());
            blocks.add((JsonElement)block);
        });
        object.add("blocks", (JsonElement)blocks);
        return object;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private WeightedRandom.Builder<BlockState> builder = new WeightedRandom.Builder();

        public Builder add(Block block) {
            return this.add(block.m_49966_(), 1);
        }

        public Builder add(Block block, int weight) {
            return this.add(block.m_49966_(), weight);
        }

        public Builder add(BlockState state) {
            return this.add(state, 1);
        }

        public Builder add(BlockState state, int weight) {
            this.builder.add(state, weight);
            return this;
        }

        public WeightedRandomBlock build() {
            return new WeightedRandomBlock(this.builder.build());
        }
    }
}

