/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.utils.pathfinding;

import com.heaser.pipeconnector.PipeConnector;
import com.heaser.pipeconnector.compatibility.CompatibilityBlockEqualsChecker;
import com.heaser.pipeconnector.config.PipeConnectorConfig;
import com.heaser.pipeconnector.utils.GeneralUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class PathfindingAStarAlgorithm {
    public static List<BlockPos> findPathAStar(BlockPos start, BlockPos end, int endY, Level level, Player player, HeuristicChecker checker) {
        PriorityQueue<Node> openSet = new PriorityQueue<Node>();
        HashSet<BlockPos> closedSet = new HashSet<BlockPos>();
        HashMap<BlockPos, Node> nodes = new HashMap<BlockPos, Node>();
        Node startNode = new Node(start, null, 0, checker.heuristic(start, end, endY));
        nodes.put(start, startNode);
        openSet.add(startNode);
        int iterationLimit = (Integer)PipeConnectorConfig.MAX_ASTAR_ITERATIONS.get();
        int iterationCount = 0;
        while (!openSet.isEmpty()) {
            if (iterationCount++ > iterationLimit) {
                PipeConnector.LOGGER.warn("{}: Exceeded iteration limit on AStar algorithm", (Object)"pipe_connector");
                return null;
            }
            Node currentNode = (Node)openSet.poll();
            BlockPos currentPos = currentNode.position;
            if (checker.isGoal(currentPos, end, endY)) {
                return PathfindingAStarAlgorithm.reconstructPath(nodes, currentNode);
            }
            closedSet.add(currentPos);
            for (BlockPos neighbor : PathfindingAStarAlgorithm.getNeighbors(currentPos, level, start, end, endY, player)) {
                if (closedSet.contains(neighbor)) continue;
                Node neighborNode = nodes.getOrDefault(neighbor, new Node(neighbor, null, Integer.MAX_VALUE, checker.heuristic(neighbor, end, endY)));
                int tentativeGCost = currentNode.gCost + 1;
                if (tentativeGCost >= neighborNode.gCost) continue;
                neighborNode.parent = currentPos;
                neighborNode.gCost = tentativeGCost;
                neighborNode.fCost = neighborNode.gCost + neighborNode.hCost;
                if (openSet.contains(neighborNode)) continue;
                nodes.put(neighbor, neighborNode);
                openSet.add(neighborNode);
            }
        }
        return null;
    }

    private static List<BlockPos> reconstructPath(Map<BlockPos, Node> nodes, Node endNode) {
        ArrayList<BlockPos> path = new ArrayList<BlockPos>();
        Node current = endNode;
        while (current != null) {
            path.add(current.position);
            current = nodes.get(current.parent);
        }
        Collections.reverse(path);
        return path;
    }

    private static List<BlockPos> getNeighbors(BlockPos pos, Level level, BlockPos start, BlockPos end, int endY, Player player) {
        BlockPos[] directions;
        ArrayList<BlockPos> neighbors = new ArrayList<BlockPos>();
        for (BlockPos neighbor : directions = new BlockPos[]{pos.m_122012_(), pos.m_122019_(), pos.m_122029_(), pos.m_122024_(), pos.m_7495_(), pos.m_7494_()}) {
            if (!PathfindingAStarAlgorithm.shouldAddNeighbor(neighbor, start, end, endY, level, player)) continue;
            neighbors.add(neighbor);
        }
        return neighbors;
    }

    private static boolean shouldAddNeighbor(BlockPos neighbor, BlockPos start, BlockPos end, int endY, Level level, Player player) {
        ItemStack offhandItem = player.m_21206_();
        Block block = level.m_8055_(neighbor).m_60734_();
        boolean isStartOrEnd = PathfindingAStarAlgorithm.isStartOrEnd(neighbor, start, end);
        boolean isAtRequiredLevel = neighbor.m_123342_() == endY;
        boolean isNotVoidable = !GeneralUtils.isVoidableBlock(level, neighbor);
        boolean canAvoid = !GeneralUtils.isPipeBlock(level, neighbor) || GeneralUtils.isOffhandItemAvoidable(level, neighbor, player);
        boolean isBlockSpecificBlock = CompatibilityBlockEqualsChecker.isBlockStateSpecificBlock(neighbor, block, offhandItem, level);
        return (isStartOrEnd || isAtRequiredLevel || isNotVoidable) && canAvoid && isBlockSpecificBlock;
    }

    private static boolean isStartOrEnd(BlockPos pos, BlockPos start, BlockPos end) {
        return pos.equals((Object)start) || pos.equals((Object)end);
    }

    static class Node
    implements Comparable<Node> {
        BlockPos position;
        BlockPos parent;
        int gCost;
        int hCost;
        int fCost;

        Node(BlockPos position, BlockPos parent, int gCost, int hCost) {
            this.position = position;
            this.parent = parent;
            this.gCost = gCost;
            this.hCost = hCost;
            this.fCost = gCost + hCost;
        }

        @Override
        public int compareTo(Node other) {
            return Integer.compare(this.fCost, other.fCost);
        }
    }

    public static interface HeuristicChecker {
        public int heuristic(BlockPos var1, BlockPos var2, int var3);

        public boolean isGoal(BlockPos var1, BlockPos var2, int var3);
    }

    public static class DepthHeuristicChecker
    implements HeuristicChecker {
        private final boolean useExistingPipes;
        private final Block placedBlock;
        private final ItemStack placedItemStack;
        private final Level level;

        public DepthHeuristicChecker(boolean useExistingPipes, Block placedBlock, ItemStack placedItemStack, Level level) {
            this.useExistingPipes = useExistingPipes;
            this.placedBlock = placedBlock;
            this.placedItemStack = placedItemStack;
            this.level = level;
        }

        @Override
        public int heuristic(BlockPos current, BlockPos end, int endY) {
            int cost = Math.abs(current.m_123342_() - endY);
            if (this.useExistingPipes) {
                CompatibilityBlockEqualsChecker.getInstance();
                if (CompatibilityBlockEqualsChecker.isBlockStateSpecificBlock(current, this.placedBlock, this.placedItemStack, this.level)) {
                    cost = (int)((double)cost * 0.3);
                }
            }
            return cost;
        }

        @Override
        public boolean isGoal(BlockPos current, BlockPos end, int endY) {
            return current.m_123342_() == endY;
        }
    }

    public static class PositionHeuristicChecker
    implements HeuristicChecker {
        private final boolean useExistingPipes;
        private final Block placedBlock;
        private final ItemStack placedItemStack;
        private final Level level;

        public PositionHeuristicChecker(boolean useExistingPipes, Block placedBlock, ItemStack placedItemStack, Level level) {
            this.useExistingPipes = useExistingPipes;
            this.placedBlock = placedBlock;
            this.placedItemStack = placedItemStack;
            this.level = level;
        }

        @Override
        public int heuristic(BlockPos current, BlockPos end, int endY) {
            int cost = Math.abs(current.m_123341_() - end.m_123341_()) + Math.abs(current.m_123343_() - end.m_123343_()) + Math.abs(current.m_123342_() - end.m_123342_());
            if (this.useExistingPipes) {
                CompatibilityBlockEqualsChecker.getInstance();
                if (CompatibilityBlockEqualsChecker.isBlockStateSpecificBlock(current, this.placedBlock, this.placedItemStack, this.level)) {
                    cost = (int)((double)cost * 0.3);
                }
            }
            return cost;
        }

        @Override
        public boolean isGoal(BlockPos current, BlockPos end, int endY) {
            return current.equals((Object)end);
        }
    }
}

