/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.network;

import com.heaser.pipeconnector.constants.BridgeType;
import com.heaser.pipeconnector.utils.GeneralUtils;
import com.heaser.pipeconnector.utils.PipeConnectorUtils;
import com.heaser.pipeconnector.utils.TagUtils;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class BuildPipesPacket {
    public BuildPipesPacket() {
    }

    public BuildPipesPacket(FriendlyByteBuf buf) {
    }

    public void encode(FriendlyByteBuf buf) {
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)context.get()).getSender();
            if (sender == null) {
                return;
            }
            if (!GeneralUtils.isHoldingPipeConnector((Player)sender)) {
                return;
            }
            ItemStack interactedItem = sender.m_21205_();
            int depth = TagUtils.getDepthFromStack(interactedItem);
            BlockPos startPosition = TagUtils.getStartPosition(interactedItem);
            BlockPos endPosition = TagUtils.getEndPosition(interactedItem);
            Direction startDirection = TagUtils.getStartDirection(interactedItem);
            Direction endDirection = TagUtils.getEndDirection(interactedItem);
            BridgeType bridgeType = TagUtils.getBridgeType(interactedItem);
            boolean utilizeExistingPipes = TagUtils.getUtilizeExistingPipes(interactedItem);
            if (startPosition == null || endPosition == null) {
                return;
            }
            BlockHitResult virtualHitResult = new BlockHitResult(Vec3.f_82478_, endDirection, endPosition, false);
            boolean wasSuccessful = PipeConnectorUtils.connectBlocks((Player)sender, startPosition, startDirection, endPosition, endDirection, depth, new UseOnContext((Player)sender, InteractionHand.MAIN_HAND, virtualHitResult), bridgeType, utilizeExistingPipes);
            TagUtils.resetPositionAndDirectionTags(interactedItem, (Player)sender, wasSuccessful);
        });
        context.get().setPacketHandled(true);
    }
}

