/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.compatibility;

import com.heaser.pipeconnector.compatibility.ae2.AE2Compatiblity;
import com.heaser.pipeconnector.compatibility.interfaces.IPlacer;
import com.heaser.pipeconnector.compatibility.prettypipes.PrettyPipesCompatibility;
import com.heaser.pipeconnector.compatibility.prettypipes.PrettyPipesFluidsCompatibility;
import com.heaser.pipeconnector.utils.GeneralUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.ModList;

public class CompatibilityPlacer {
    private static CompatibilityPlacer INSTANCE;
    private final HashMap<Class<? extends Item>, IPlacer> itemClassToPlacerMap = new HashMap();
    private final HashMap<Class<? extends Block>, IPlacer> blockClassToPlacerMap = new HashMap();

    private CompatibilityPlacer() {
        if (this.isModLoaded("ae2")) {
            this.itemClassToPlacerMap.put(AE2Compatiblity.getItemStackClassToRegister(), new AE2Compatiblity());
        }
        if (this.isModLoaded("prettypipes")) {
            this.blockClassToPlacerMap.put(PrettyPipesCompatibility.getBlockToRegister(), new PrettyPipesCompatibility());
        }
        if (this.isModLoaded("ppfluids")) {
            this.blockClassToPlacerMap.put(PrettyPipesFluidsCompatibility.getBlockToRegister(), new PrettyPipesCompatibility());
        }
    }

    private boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public static CompatibilityPlacer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CompatibilityPlacer();
        }
        return INSTANCE;
    }

    public boolean defaultPlace(Level level, BlockPos pos, Player player, Item item) {
        if (!GeneralUtils.isVoidableBlock(level, pos)) {
            level.m_142052_(pos, level.m_8055_(pos));
            level.m_46953_(pos, true, (Entity)player);
        }
        BlockState blockState = Block.m_49814_((Item)item).m_49966_();
        return level.m_46597_(pos, blockState);
    }

    public boolean place(Level level, BlockPos pos, Player player, ItemStack stack) {
        IPlacer placer = null;
        Item item = stack.m_41720_();
        for (Map.Entry<Class<? extends Item>, IPlacer> entry : this.itemClassToPlacerMap.entrySet()) {
            if (!entry.getKey().isAssignableFrom(item.getClass())) continue;
            placer = entry.getValue();
            break;
        }
        if (placer == null && item instanceof BlockItem) {
            for (Map.Entry<Class<? extends Item>, IPlacer> entry : this.blockClassToPlacerMap.entrySet()) {
                if (!((BlockItem)item).m_40614_().getClass().isAssignableFrom(entry.getKey())) continue;
                placer = entry.getValue();
                break;
            }
        }
        if (placer != null) {
            return placer.place(level, pos, player, stack.m_41720_());
        }
        return this.defaultPlace(level, pos, player, stack.m_41720_());
    }
}

