/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.machines.metal_processing.coke_oven;

import com.drmangotea.tfmg.blocks.machines.TFMGMachineBlockEntity;
import com.drmangotea.tfmg.blocks.machines.metal_processing.coke_oven.CokeOvenBlock;
import com.drmangotea.tfmg.recipes.coking.CokingRecipe;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.drmangotea.tfmg.registry.TFMGRecipeTypes;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class CokeOvenBlockEntity
extends TFMGMachineBlockEntity
implements IWrenchable {
    public boolean isController = false;
    public CokeOvenBlockEntity controller;
    public CokingRecipe lastRecipe;
    int progress = 0;
    public LerpedFloat visualDoorAngle = LerpedFloat.angular();
    public int doorAngle = 0;
    public int timer = -1;
    public SmartInventory inputInventory = new SmartInventory(1, (SyncedBlockEntity)this).withMaxStackSize(64);
    public LazyOptional<IItemHandlerModifiable> itemCapability = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputInventory}));
    public final int CARBON_DIOXIDE_PRODUCTION = 9;

    public CokeOvenBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.tank2.forbidInsertion();
        this.tank1.forbidInsertion();
    }

    public void tick() {
        super.tick();
        if (this.controller == null) {
            this.controller = this;
            this.inputInventory.forbidInsertion();
        } else {
            this.inputInventory.allowInsertion();
        }
        this.visualDoorAngle.chase((double)this.doorAngle, (double)0.2f, LerpedFloat.Chaser.EXP);
        this.visualDoorAngle.tickChaser();
        if (this.isController) {
            this.controller = this;
        }
        this.setControllers();
        if (this.controller != null && !this.controller.isController) {
            this.controller = this;
        }
        if (this.controller != null && !(this.f_58857_.m_7702_(this.controller.m_58899_()) instanceof CokeOvenBlockEntity)) {
            this.controller = this;
        }
        this.setBlockState();
        this.setTimer();
        if (this.lastRecipe != null) {
            this.progress = this.timer == -1 ? 0 : 100 - this.timer / (this.lastRecipe.getProcessingDuration() / 100);
        }
        this.doorAngle = this.timer >= 0 && this.timer < 44 ? 90 : 0;
        if (this.timer == 0) {
            this.timer = -1;
            this.process();
        }
        RecipeWrapper inventoryIn = new RecipeWrapper((IItemHandlerModifiable)this.inputInventory);
        if (this.lastRecipe == null || !this.lastRecipe.matches(inventoryIn, this.f_58857_) && this.timer == -1) {
            Optional recipe = TFMGRecipeTypes.COKING.find(inventoryIn, this.f_58857_);
            if (!recipe.isPresent()) {
                this.timer = -1;
                this.sendData();
            } else {
                this.lastRecipe = (CokingRecipe)((Object)recipe.get());
                this.sendData();
            }
            return;
        }
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.inputInventory);
    }

    public void setBlockState() {
        if (this.controller == this) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(CokeOvenBlock.CONTROLLER_TYPE, (Comparable)((Object)CokeOvenBlock.ControllerType.CASUAL)), 2);
        }
        if (!this.isController) {
            return;
        }
        if (this.timer == -1) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(CokeOvenBlock.CONTROLLER_TYPE, (Comparable)((Object)CokeOvenBlock.ControllerType.MIDDLE_OFF)), 2);
            if (this.f_58857_.m_7702_(this.m_58899_().m_7495_()) instanceof CokeOvenBlockEntity) {
                this.f_58857_.m_7731_(this.m_58899_().m_7495_(), (BlockState)((BlockState)this.f_58857_.m_8055_(this.m_58899_().m_7495_()).m_61124_(CokeOvenBlock.CONTROLLER_TYPE, (Comparable)((Object)CokeOvenBlock.ControllerType.BOTTOM_OFF))).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_))), 2);
            }
            if (this.f_58857_.m_7702_(this.m_58899_().m_7494_()) instanceof CokeOvenBlockEntity) {
                this.f_58857_.m_7731_(this.m_58899_().m_7494_(), (BlockState)((BlockState)this.f_58857_.m_8055_(this.m_58899_().m_7494_()).m_61124_(CokeOvenBlock.CONTROLLER_TYPE, (Comparable)((Object)CokeOvenBlock.ControllerType.TOP_OFF))).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_))), 2);
            }
        } else {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(CokeOvenBlock.CONTROLLER_TYPE, (Comparable)((Object)CokeOvenBlock.ControllerType.MIDDLE_ON)), 2);
            if (this.f_58857_.m_7702_(this.m_58899_().m_7495_()) instanceof CokeOvenBlockEntity) {
                this.f_58857_.m_7731_(this.m_58899_().m_7495_(), (BlockState)((BlockState)this.f_58857_.m_8055_(this.m_58899_().m_7495_()).m_61124_(CokeOvenBlock.CONTROLLER_TYPE, (Comparable)((Object)CokeOvenBlock.ControllerType.BOTTOM_ON))).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_))), 2);
            }
            if (this.f_58857_.m_7702_(this.m_58899_().m_7494_()) instanceof CokeOvenBlockEntity) {
                this.f_58857_.m_7731_(this.m_58899_().m_7494_(), (BlockState)((BlockState)this.f_58857_.m_8055_(this.m_58899_().m_7494_()).m_61124_(CokeOvenBlock.CONTROLLER_TYPE, (Comparable)((Object)CokeOvenBlock.ControllerType.TOP_ON))).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_))), 2);
            }
        }
    }

    private void setTimer() {
        if (this.lastRecipe != null && this.isController && this.timer == -1 && this.inputInventory.m_8020_(0).m_41613_() >= 1 && this.tank2.getPrimaryHandler().getFluidAmount() + 9 <= this.tank2.getPrimaryHandler().getCapacity() && this.tank1.getPrimaryHandler().getFluidAmount() + ((FluidStack)this.lastRecipe.getFluidResults().get(0)).getAmount() <= this.tank1.getPrimaryHandler().getCapacity()) {
            this.timer = this.lastRecipe.getProcessingDuration();
            this.inputInventory.m_6836_(0, new ItemStack((ItemLike)this.inputInventory.m_8020_(0).m_41720_(), this.inputInventory.m_8020_(0).m_41613_() - 1));
        }
        if (this.lastRecipe != null && this.timer > 0 && this.isController && this.tank2.getPrimaryHandler().getFluidAmount() + 9 <= this.tank2.getPrimaryHandler().getCapacity() && this.tank1.getPrimaryHandler().getFluidAmount() + ((FluidStack)this.lastRecipe.getFluidResults().get(0)).getAmount() <= this.tank1.getPrimaryHandler().getCapacity()) {
            --this.timer;
            this.tank1.getPrimaryHandler().setFluid(new FluidStack((FluidStack)this.lastRecipe.getFluidResults().get(0), this.tank1.getPrimaryHandler().getFluidAmount() + ((FluidStack)this.lastRecipe.getFluidResults().get(0)).getAmount()));
        }
    }

    public void process() {
        if (!this.isController) {
            return;
        }
        BlockPos toSpawn = this.m_58899_().m_7495_().m_121945_((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_));
        if (this.lastRecipe == null) {
            return;
        }
        ItemEntity itemToSpawn = new ItemEntity(this.f_58857_, (double)((float)toSpawn.m_123341_() + 0.5f), (double)((float)toSpawn.m_123342_() + 0.5f), (double)((float)toSpawn.m_123343_() + 0.5f), this.lastRecipe.m_8043_(null).m_41777_());
        this.f_58857_.m_7967_((Entity)itemToSpawn);
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().m_82363_(0.0, -2.0, 0.0).m_82363_(0.0, 2.0, 0.0);
    }

    private void refreshCapability() {
        if (this.controller != null && this.controller.tank1 != null && this.controller.tank2 != null && this.controller.inputInventory != null) {
            this.fluidCapability = LazyOptional.of(() -> new CombinedTankWrapper(new IFluidHandler[]{this.controller.tank1.getPrimaryHandler(), this.controller.tank2.getPrimaryHandler()}));
            this.itemCapability = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.controller.inputInventory}));
        }
    }

    public void setControllers() {
        if (!this.isValid()) {
            return;
        }
        if (!this.isController) {
            return;
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        BlockPos checkedPos = this.m_58899_().m_7494_();
        for (int i = 0; i < 3; ++i) {
            for (int y = 0; y < 3; ++y) {
                CokeOvenBlockEntity checkedBE = (CokeOvenBlockEntity)this.f_58857_.m_7702_(checkedPos);
                checkedBE.controller = this;
                if (checkedBE.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_) != this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)) {
                    this.f_58857_.m_7731_(checkedPos, (BlockState)checkedBE.m_58900_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_))), 2);
                }
                checkedPos = checkedPos.m_7495_();
            }
            checkedPos = checkedPos.m_6630_(3);
            checkedPos = checkedPos.m_121945_(facing.m_122424_());
        }
    }

    public boolean isValid() {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        BlockPos checkedPos = this.m_58899_().m_7494_();
        if (this.controller != this) {
            this.isController = false;
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            for (int y = 0; y < 3; ++y) {
                if (checkedPos == this.m_58899_()) {
                    if (!this.isCokeOvenBlock(checkedPos, true)) {
                        this.isController = false;
                        return false;
                    }
                } else if (!this.isCokeOvenBlock(checkedPos)) {
                    this.isController = false;
                    return false;
                }
                if (this.occupiedByOtherController(checkedPos)) {
                    this.isController = false;
                    return false;
                }
                checkedPos = checkedPos.m_7495_();
            }
            checkedPos = checkedPos.m_6630_(3);
            checkedPos = checkedPos.m_121945_(facing.m_122424_());
        }
        return true;
    }

    public boolean isCokeOvenBlock(BlockPos pos) {
        return this.isCokeOvenBlock(pos, false);
    }

    public boolean isCokeOvenBlock(BlockPos pos, boolean controllerSensitive) {
        if (controllerSensitive && this.f_58857_.m_8055_(pos).m_60713_((Block)TFMGBlocks.COKE_OVEN.get()) && this.isController) {
            return false;
        }
        return this.f_58857_.m_8055_(pos).m_60713_((Block)TFMGBlocks.COKE_OVEN.get());
    }

    public boolean occupiedByOtherController(BlockPos pos) {
        if (this.controller == null) {
            this.controller = this;
        }
        return !this.f_58857_.m_7702_(pos).m_58900_().m_60713_((Block)TFMGBlocks.COKE_OVEN.get()) || ((CokeOvenBlockEntity)this.f_58857_.m_7702_((BlockPos)pos)).controller != ((CokeOvenBlockEntity)this.f_58857_.m_7702_((BlockPos)pos)).controller && ((CokeOvenBlockEntity)this.f_58857_.m_7702_((BlockPos)pos)).controller != this;
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (this.controller != null && this.controller.m_58899_() == this.m_58899_() && !this.isValid()) {
            Lang.translate((String)"goggles.coke_oven.invalid", (Object[])new Object[0]).style(ChatFormatting.DARK_RED).forGoggles(tooltip, 1);
            return true;
        }
        if (!this.isController) {
            return false;
        }
        if (this.lastRecipe != null && this.tank1.getPrimaryHandler().getFluidAmount() + ((FluidStack)this.lastRecipe.getFluidResults().get(0)).getAmount() > this.tank1.getPrimaryHandler().getCapacity() && this.tank2.getPrimaryHandler().getFluidAmount() + 9 > this.tank2.getPrimaryHandler().getCapacity()) {
            Lang.translate((String)"goggles.coke_oven.tank_full", (Object[])new Object[0]).style(ChatFormatting.DARK_RED).forGoggles(tooltip, 1);
            return true;
        }
        Lang.translate((String)"goggles.coke_oven.status", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
        Lang.translate((String)"goggles.coke_oven.progress", (Object[])new Object[]{this.progress}).add(Lang.translate((String)"goggles.misc.percent_symbol", (Object[])new Object[0])).style(ChatFormatting.DARK_PURPLE).forGoggles(tooltip, 1);
        Lang.translate((String)"goggles.misc.storage_info", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
        Lang.translate((String)"goggles.coke_oven.item_count", (Object[])new Object[]{this.inputInventory.m_8020_(0).m_41613_()}).style(ChatFormatting.GOLD).forGoggles(tooltip, 1);
        return true;
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.inputInventory.deserializeNBT(compound.m_128469_("InputItems"));
        this.isController = compound.m_128471_("Is Controller");
        this.timer = compound.m_128451_("Timer");
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("InputItems", (Tag)this.inputInventory.serializeNBT());
        compound.m_128379_("Is Controller", this.isController);
        compound.m_128405_("Timer", this.timer);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.itemCapability.invalidate();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (this.controller != null) {
            this.refreshCapability();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemCapability.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
    }
}

